/*
 * Decompiled with CFR 0.152.
 */
package mark.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import mark.core.DataAgentInterface;
import mark.core.InvalidProfileException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class DataAgentProfile {
    public String class_name;
    public String label;
    public Map<String, String> parameters;
    public File path;
    private static final Yaml PARSER = new Yaml((BaseConstructor)new Constructor(DataAgentProfile.class));

    public static final DataAgentProfile fromFile(File file) throws FileNotFoundException {
        DataAgentProfile profile = DataAgentProfile.fromInputStream(new FileInputStream(file));
        profile.path = file;
        return profile;
    }

    public static final DataAgentProfile fromInputStream(InputStream input) {
        return (DataAgentProfile)PARSER.loadAs(input, DataAgentProfile.class);
    }

    public final DataAgentInterface createInstance() throws InvalidProfileException {
        try {
            return (DataAgentInterface)Class.forName(this.class_name).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidProfileException("Cannot instantiate data agent " + this.class_name, ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidProfileException("Cannot instantiate data agent " + this.class_name, ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidProfileException("Cannot instantiate data agent " + this.class_name, ex);
        }
    }

    public final File getPath(String filename) throws FileNotFoundException {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            if (this.path == null) {
                throw new FileNotFoundException("provided modules directory is not valid (not a directory or no a valid path)");
            }
            file = new File(this.path.toURI().resolve(filename));
        }
        return file;
    }
}

