/*
 * Decompiled with CFR 0.152.
 */
package be.cylab.mark.client;

import be.cylab.mark.client.EvidenceTimeComparator;
import be.cylab.mark.core.DetectionAgentProfile;
import be.cylab.mark.core.Evidence;
import be.cylab.mark.core.RawData;
import be.cylab.mark.core.ServerInterface;
import be.cylab.mark.core.Subject;
import be.cylab.mark.core.SubjectAdapter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;

public class Client<T extends Subject>
implements ServerInterface {
    private static final int CONNECTION_TIMEOUT = 5000;
    private final JsonRpcHttpClient json_rpc_client;
    private final URL server_url;

    public Client(URL server_url, SubjectAdapter adapter) {
        this.server_url = server_url;
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(RawData.class, new RawDataDezerializer(adapter));
        module.addDeserializer(Evidence.class, (JsonDeserializer)new EvidenceDeserializer(adapter));
        mapper.registerModule((Module)module);
        this.json_rpc_client = new JsonRpcHttpClient(mapper, server_url, new HashMap());
        this.json_rpc_client.setConnectionTimeoutMillis(5000);
    }

    public final String test() throws Throwable {
        return (String)this.json_rpc_client.invoke("test", null, String.class);
    }

    public final void addRawData(RawData data) throws Throwable {
        this.json_rpc_client.invoke("addRawData", (Object)new Object[]{data});
    }

    public final ObjectId addFile(byte[] bytes, String filename) throws Throwable {
        return (ObjectId)this.json_rpc_client.invoke("addFile", (Object)new Object[]{bytes, filename}, ObjectId.class);
    }

    public final byte[] findFile(ObjectId file_id) throws Throwable {
        return (byte[])this.json_rpc_client.invoke("findFile", (Object)new Object[]{file_id}, byte[].class);
    }

    public final void testString(String data) throws Throwable {
        this.json_rpc_client.invoke("testString", (Object)new Object[]{data});
    }

    public final RawData[] findData(Document query) throws Throwable {
        return (RawData[])this.json_rpc_client.invoke("findData", (Object)new Object[]{query}, RawData[].class);
    }

    public final RawData[] findData(String json_query) throws Throwable {
        ObjectNode node = (ObjectNode)new ObjectMapper().readValue(json_query, ObjectNode.class);
        return (RawData[])this.json_rpc_client.invoke(node, RawData[].class, new HashMap());
    }

    public final RawData[] findRawData(String label, Subject subject, long from, long till) throws Throwable {
        return (RawData[])this.json_rpc_client.invoke("findRawData", (Object)new Object[]{label, subject, from, till}, RawData[].class);
    }

    public final Evidence[] findEvidence(String label, Subject subject) throws Throwable {
        Evidence[] evidences = (Evidence[])this.json_rpc_client.invoke("findEvidence", (Object)new Object[]{label, subject}, Evidence[].class);
        Arrays.sort(evidences, new EvidenceTimeComparator());
        return evidences;
    }

    public final Evidence findEvidenceById(String id) throws Throwable {
        return (Evidence)this.json_rpc_client.invoke("findEvidenceById", (Object)new Object[]{id}, Evidence.class);
    }

    public final void addEvidence(Evidence evidence) throws Throwable {
        this.json_rpc_client.invoke("addEvidence", (Object)new Object[]{evidence});
    }

    public final Evidence[] findEvidence(String label) throws Throwable {
        return (Evidence[])this.json_rpc_client.invoke("findEvidence", (Object)new Object[]{label}, Evidence[].class);
    }

    public final Evidence[] findEvidence(String label, int page) throws Throwable {
        return (Evidence[])this.json_rpc_client.invoke("findEvidence", (Object)new Object[]{label, page}, Evidence[].class);
    }

    public final Evidence[] findLastEvidences(String label, Subject subject) throws Throwable {
        return (Evidence[])this.json_rpc_client.invoke("findLastEvidences", (Object)new Object[]{label, subject}, Evidence[].class);
    }

    public final URL getURL() {
        return this.server_url;
    }

    public final Object getFromCache(String key) throws Throwable {
        return this.json_rpc_client.invoke("getFromCache", (Object)new Object[]{key}, Object.class);
    }

    public final void storeInCache(String key, Object value) throws Throwable {
        this.json_rpc_client.invoke("storeInCache", (Object)new Object[]{key, value}, Object.class);
    }

    public final boolean compareAndSwapInCache(String key, Object new_value, Object old_value) throws Throwable {
        return (Boolean)this.json_rpc_client.invoke("compareAndSwapInCache", (Object)new Object[]{key, new_value, old_value}, Boolean.class);
    }

    public final DetectionAgentProfile[] activation() throws Throwable {
        return (DetectionAgentProfile[])this.json_rpc_client.invoke("activation", null, DetectionAgentProfile[].class);
    }

    public final Map executorStatus() throws Throwable {
        return (Map)this.json_rpc_client.invoke("executorStatus", null, Map.class);
    }

    public final Evidence[] findEvidenceSince(String label, Subject subject, long time) throws Throwable {
        Evidence[] evidences = (Evidence[])this.json_rpc_client.invoke("findEvidenceSince", (Object)new Object[]{label, subject, time}, Evidence[].class);
        Arrays.sort(evidences, new EvidenceTimeComparator());
        return evidences;
    }

    public final JsonRpcClient getJsonRpcClient() {
        return this.json_rpc_client;
    }

    public final void pause() throws Throwable {
        this.json_rpc_client.invoke("pause", null);
    }

    public final void resume() throws Throwable {
        this.json_rpc_client.invoke("resume", null);
    }

    public final Map status() throws Throwable {
        return (Map)this.json_rpc_client.invoke("status", null, Map.class);
    }

    public final Map dbStatus() throws Throwable {
        return (Map)this.json_rpc_client.invoke("dbStatus", null, Map.class);
    }

    private static class EvidenceDeserializer
    extends JsonDeserializer<Evidence> {
        private final SubjectAdapter adapter;

        EvidenceDeserializer(SubjectAdapter adapter) {
            this.adapter = adapter;
        }

        public Evidence deserialize(JsonParser jparser, DeserializationContext ctx) throws IOException, JsonProcessingException {
            TreeNode tree = jparser.getCodec().readTree(jparser);
            Evidence ev = new Evidence();
            ev.setId(((TextNode)tree.get("id")).asText());
            ev.setReport(((TextNode)tree.get("report")).asText());
            ev.setLabel(((TextNode)tree.get("label")).asText());
            ev.setScore(((NumericNode)tree.get("score")).asDouble());
            ev.setTime(((NumericNode)tree.get("time")).asLong());
            ev.setReferences(this.deserializeList((ArrayNode)tree.get("references")));
            ev.setRequests(this.deserializeList((ArrayNode)tree.get("requests")));
            ev.setProfile(this.deserializeProfile(tree.get("profile")));
            ev.setSubject(this.adapter.deserialize((JsonNode)tree.get("subject")));
            return ev;
        }

        private List<String> deserializeList(ArrayNode node) {
            ArrayList<String> values = new ArrayList<String>();
            for (JsonNode element : node) {
                values.add(element.asText());
            }
            return values;
        }

        private DetectionAgentProfile deserializeProfile(TreeNode node) throws JsonProcessingException {
            DetectionAgentProfile profile = new DetectionAgentProfile();
            profile.setClassName(((TextNode)node.get("className")).asText());
            profile.setLabel(((TextNode)node.get("label")).asText());
            profile.setTriggerLabel(((TextNode)node.get("triggerLabel")).asText());
            ObjectMapper mapper = new ObjectMapper();
            HashMap parameters = (HashMap)mapper.treeToValue(node.get("parameters"), HashMap.class);
            profile.setParameters(parameters);
            return profile;
        }
    }

    private static class RawDataDezerializer<T extends Subject>
    extends JsonDeserializer<RawData> {
        private final SubjectAdapter<T> adapter;

        RawDataDezerializer(SubjectAdapter<T> adapter) {
            this.adapter = adapter;
        }

        public RawData deserialize(JsonParser jparser, DeserializationContext context) throws IOException, JsonProcessingException {
            TreeNode tree = jparser.getCodec().readTree(jparser);
            RawData data = new RawData();
            data.setId(((TextNode)tree.get("id")).asText());
            data.setData(((TextNode)tree.get("data")).asText());
            data.setLabel(((TextNode)tree.get("label")).asText());
            data.setTime(((NumericNode)tree.get("time")).asLong());
            data.setSubject(this.adapter.deserialize((JsonNode)tree.get("subject")));
            return data;
        }
    }
}

