/*
 * Decompiled with CFR 0.152.
 */
package mark.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import mark.core.Evidence;
import mark.core.RawData;
import mark.core.ServerInterface;
import mark.core.Subject;
import mark.core.SubjectAdapter;
import org.bson.Document;
import org.bson.types.ObjectId;

public class Client<T extends Subject>
implements ServerInterface {
    private static final int CONNECTION_TIMEOUT = 5000;
    private final JsonRpcHttpClient datastore;
    private URL server_url;

    public Client(URL server_url, SubjectAdapter adapter) {
        this.server_url = server_url;
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(RawData.class, new RawDataDezerializer(adapter));
        module.addDeserializer(Evidence.class, (JsonDeserializer)new EvidenceDeserializer(adapter));
        mapper.registerModule((Module)module);
        this.datastore = new JsonRpcHttpClient(mapper, server_url, new HashMap());
        this.datastore.setConnectionTimeoutMillis(5000);
    }

    public final String test() throws Throwable {
        return (String)this.datastore.invoke("test", null, String.class);
    }

    public final void addRawData(RawData data) throws Throwable {
        this.datastore.invoke("addRawData", (Object)new Object[]{data});
    }

    public final ObjectId addFile(byte[] bytes, String filename) throws Throwable {
        return (ObjectId)this.datastore.invoke("addFile", (Object)new Object[]{bytes, filename}, ObjectId.class);
    }

    public byte[] findFile(ObjectId file_id) throws Throwable {
        return (byte[])this.datastore.invoke("findFile", (Object)new Object[]{file_id}, byte[].class);
    }

    public final void testString(String data) throws Throwable {
        this.datastore.invoke("testString", (Object)new Object[]{data});
    }

    public final RawData[] findData(Document query) throws Throwable {
        return (RawData[])this.datastore.invoke("findData", (Object)new Object[]{query}, RawData[].class);
    }

    public final RawData[] findRawData(String label, Subject subject) throws Throwable {
        return (RawData[])this.datastore.invoke("findRawData", (Object)new Object[]{label, subject}, RawData[].class);
    }

    public final Evidence[] findEvidence(String label, Subject subject) throws Throwable {
        return (Evidence[])this.datastore.invoke("findEvidence", (Object)new Object[]{label, subject}, Evidence[].class);
    }

    public final Evidence findEvidenceById(String id) throws Throwable {
        return (Evidence)this.datastore.invoke("findEvidenceById", (Object)new Object[]{id}, Evidence.class);
    }

    public final void addEvidence(Evidence evidence) throws Throwable {
        this.datastore.invoke("addEvidence", (Object)new Object[]{evidence});
    }

    public final Evidence[] findEvidence(String label) throws Throwable {
        return (Evidence[])this.datastore.invoke("findEvidence", (Object)new Object[]{label}, Evidence[].class);
    }

    public Evidence[] findLastEvidences(String label, Subject subject) throws Throwable {
        return (Evidence[])this.datastore.invoke("findLastEvidences", (Object)new Object[]{label, subject}, Evidence[].class);
    }

    public final URL getURL() {
        return this.server_url;
    }

    public Object getFromCache(String key) throws Throwable {
        return this.datastore.invoke("getFromCache", (Object)new Object[]{key}, Object.class);
    }

    public void storeInCache(String key, Object value) throws Throwable {
        this.datastore.invoke("storeInCache", (Object)new Object[]{key, value}, Object.class);
    }

    public boolean compareAndSwapInCache(String key, Object new_value, Object old_value) throws Throwable {
        return (Boolean)this.datastore.invoke("compareAndSwapInCache", (Object)new Object[]{key, new_value, old_value}, Boolean.class);
    }

    private static class EvidenceDeserializer
    extends JsonDeserializer<Evidence> {
        private final SubjectAdapter adapter;

        EvidenceDeserializer(SubjectAdapter adapter) {
            this.adapter = adapter;
        }

        public Evidence deserialize(JsonParser jparser, DeserializationContext ctx) throws IOException, JsonProcessingException {
            TreeNode tree = jparser.getCodec().readTree(jparser);
            Evidence data = new Evidence();
            data.report = ((TextNode)tree.get("report")).asText();
            data.label = ((TextNode)tree.get("label")).asText();
            data.score = ((NumericNode)tree.get("score")).asDouble();
            data.time = ((NumericNode)tree.get("time")).asInt();
            data.subject = this.adapter.deserialize((JsonNode)tree.get("subject"));
            return data;
        }
    }

    private static class RawDataDezerializer<T extends Subject>
    extends JsonDeserializer<RawData> {
        private final SubjectAdapter<T> adapter;

        RawDataDezerializer(SubjectAdapter<T> adapter) {
            this.adapter = adapter;
        }

        public RawData deserialize(JsonParser jparser, DeserializationContext context) throws IOException, JsonProcessingException {
            TreeNode tree = jparser.getCodec().readTree(jparser);
            RawData data = new RawData();
            data.data = ((TextNode)tree.get("data")).asText();
            data.label = ((TextNode)tree.get("label")).asText();
            data.time = ((NumericNode)tree.get("time")).asInt();
            data.subject = this.adapter.deserialize((JsonNode)tree.get("subject"));
            return data;
        }
    }
}

