/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.runtime.strategy;

import be.cloudway.gramba.runtime.GrambaRuntime;
import be.cloudway.gramba.runtime.Invocation;
import be.cloudway.gramba.runtime.api.HttpClient;
import be.cloudway.gramba.runtime.aws.runtime.implementation.AwsUrlBuilder;
import be.cloudway.gramba.runtime.helpers.JacksonHelper;
import be.cloudway.gramba.runtime.helpers.UrlType;
import be.cloudway.gramba.runtime.model.ApiResponse;
import be.cloudway.gramba.runtime.model.ErrorResponse;
import be.cloudway.gramba.runtime.strategy.AwsApiStrategy;

public class DefaultAwsApiStrategy
implements AwsApiStrategy {
    private static final HttpClient httpClient = new HttpClient();
    private AwsUrlBuilder awsUrlBuilder;
    private JacksonHelper jacksonHelper;

    public DefaultAwsApiStrategy() {
        this.awsUrlBuilder = GrambaRuntime.STATIC_REFERENCES.awsUrlBuilder;
        this.jacksonHelper = GrambaRuntime.STATIC_REFERENCES.jacksonHelper;
    }

    @Override
    public void postInitError(Exception ex) {
        httpClient.post(this.awsUrlBuilder.getUrl(UrlType.INIT_ERROR), this.jacksonHelper.fromObj(new ErrorResponse(ex)), httpClient.getDefaultHeaders());
    }

    @Override
    public ApiResponse getNextInvocation() {
        return httpClient.get(this.awsUrlBuilder.getUrl(UrlType.NEXT_INVOCATION));
    }

    @Override
    public ApiResponse postInvocationResponse(Invocation invocation, Object response) {
        return httpClient.post(this.awsUrlBuilder.getUrl(UrlType.RESPONSE, invocation.getRequestId()), this.jacksonHelper.fromObj(response), httpClient.getDefaultHeaders());
    }

    @Override
    public void postInvocationError(Invocation invocation, Exception ex) {
        httpClient.post(this.awsUrlBuilder.getUrl(UrlType.ERROR, invocation.getRequestId()), this.jacksonHelper.fromObj(new ErrorResponse(ex)), httpClient.getDefaultHeaders());
    }
}

