/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.runtime.eventrunner;

import be.cloudway.gramba.runtime.GrambaRuntime;
import be.cloudway.gramba.runtime.Invocation;
import be.cloudway.gramba.runtime.aws.runtime.implementation.AwsUrlBuilder;
import be.cloudway.gramba.runtime.eventrunner.EventRunnerInterface;
import be.cloudway.gramba.runtime.handler.GrambaLambdaHandler;
import be.cloudway.gramba.runtime.helpers.JacksonHelper;
import be.cloudway.gramba.runtime.model.ApiResponse;
import be.cloudway.gramba.runtime.strategy.AwsApiStrategy;

public abstract class EventRunner
implements EventRunnerInterface {
    private AwsApiStrategy awsApiStrategy;
    private GrambaLambdaHandler requestHandler;
    private JacksonHelper jacksonHelper;
    private AwsUrlBuilder awsUrlBuilder;

    protected EventRunner(GrambaLambdaHandler requestHandler, AwsApiStrategy awsApiStrategy) {
        this.jacksonHelper = GrambaRuntime.STATIC_REFERENCES.jacksonHelper;
        this.awsUrlBuilder = GrambaRuntime.STATIC_REFERENCES.awsUrlBuilder;
        this.requestHandler = requestHandler;
        this.awsApiStrategy = awsApiStrategy;
    }

    protected void runNextInvocation() {
        try {
            Invocation invocation = this.getInvocation();
            this.processInvocation(invocation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.awsApiStrategy.postInitError(ex);
        }
    }

    private void processInvocation(Invocation invocation) {
        try {
            Object response = this.requestHandler.customHandler(invocation.getWebResponse(), invocation.getWebResponse().getHeaders(), this.jacksonHelper);
            this.awsApiStrategy.postInvocationResponse(invocation, response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.awsApiStrategy.postInvocationError(invocation, ex);
        }
    }

    private Invocation getInvocation() {
        ApiResponse apiResponse = this.awsApiStrategy.getNextInvocation();
        return new Invocation(this.awsUrlBuilder.getApiEndpoint(), apiResponse.getHeaders().get("Lambda-Runtime-Aws-Request-Id").get(0), apiResponse);
    }
}

