/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.runtime.dev.addons.commands;

import be.cloudway.gramba.runtime.dev.addons.model.GrambaSettings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandHandler {
    private Options getOptions() {
        Options options = new Options();
        Option testing = new Option("t", "testMode", false, "If set, the AWS API Lambda will be ignored and mock requests can be used.");
        testing.setRequired(false);
        options.addOption(testing);
        Option mockObject = new Option("m", "mockObject", true, "A reference to a json file that can act as a request object");
        mockObject.setRequired(false);
        options.addOption(mockObject);
        return options;
    }

    private GrambaSettings validateOptions(CommandLine cmd) {
        GrambaSettings gralaSettings = new GrambaSettings();
        gralaSettings.setTestMode(cmd.hasOption("testMode"));
        gralaSettings.setPathToMockJson(cmd.getOptionValue("mockObject"));
        gralaSettings.setDebugMode(Boolean.valueOf(System.getenv("debug")));
        return gralaSettings;
    }

    public GrambaSettings validateArgs(String ... args) {
        CommandLine cmd;
        Options options = this.getOptions();
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            formatter.printHelp("Gramba", options);
            System.exit(1);
            return null;
        }
        return this.validateOptions(cmd);
    }
}

