/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.nativeimage.helper;

import java.io.IOException;
import java.io.OutputStream;

public final class TeeOutputStream
extends OutputStream {
    private final OutputStream out;
    private final OutputStream tee;

    public TeeOutputStream(OutputStream out, OutputStream tee) {
        if (out == null) {
            throw new NullPointerException();
        }
        if (tee == null) {
            throw new NullPointerException();
        }
        this.out = out;
        this.tee = tee;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.tee.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.tee.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.tee.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.tee.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.tee.close();
        }
    }

    public void closeTeeOnly() throws IOException {
        this.tee.close();
    }

    public void flushTeeOnly() throws IOException {
        this.tee.flush();
    }
}

