/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.nativeimage;

import be.cloudway.gramba.nativeimage.NativeImageMain;
import be.cloudway.gramba.nativeimage.commands.BuildCommand;
import be.cloudway.gramba.nativeimage.helper.DockerHelper;
import be.cloudway.gramba.nativeimage.helper.TeeOutputStream;
import be.cloudway.gramba.nativeimage.helper.ZipHelper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class NativeImageHandler {
    private BuildCommand commandBuilder;
    private DockerHelper dockerHelper;
    private final NativeImageMain m;
    private Log log;

    public NativeImageHandler(Log log, NativeImageMain main) {
        this.log = log;
        this.commandBuilder = new BuildCommand(log);
        this.dockerHelper = new DockerHelper(log);
        this.m = main;
    }

    private void zip(boolean createZip, File baseDir) throws MojoFailureException {
        if (!createZip) {
            return;
        }
        this.log.info((CharSequence)"Creating function.zip file");
        ZipHelper.toFunctionZip(baseDir.getAbsolutePath() + "/target/function", baseDir + "/target/function.zip");
    }

    private void validateOutput(String output) throws MojoFailureException {
        if (!output.contains("-- BUILD SUCCESSFUL --")) {
            throw new MojoFailureException("Build failed!");
        }
        if (!output.contains("-- TESTS SUCCESSFUL --") && !output.contains("-- NO TESTS --")) {
            throw new MojoFailureException("Tests failed!");
        }
    }

    private String getCommand() {
        return this.commandBuilder.getCommand(this.m.getDelayedClasses(), this.m.getInjectionFiles(), this.m.getOutputDirectory(), this.m.getAdditionalOptions(), this.m.getJarName(), this.m.getTestFiles(), this.m.isSkipBuild());
    }

    public void run() throws MojoExecutionException {
        String localDockerHost = SystemUtils.IS_OS_WINDOWS ? "tcp://localhost:2375" : "unix:///var/run/docker.sock";
        DockerClient dockerClient = DockerClientBuilder.getInstance((String)localDockerHost).build();
        this.log.info((CharSequence)("Pulling docker image: " + this.m.getDockerImage() + ":" + this.m.getDockerImageTag()));
        try {
            (dockerClient.pullImageCmd(this.m.getDockerImage()).withTag(this.m.getDockerImageTag()).exec((ResultCallback)new PullImageResultCallback(){

                public void onNext(PullResponseItem item) {
                    super.onNext(item);
                }
            })).awaitCompletion();
            this.log.info((CharSequence)"Finished pulling docker image");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.log.info((CharSequence)"Creating docker container");
        String containerId = this.dockerHelper.createContainer(dockerClient, this.m.getBaseDir(), this.m.getEnvVariables(), this.m.getDockerImage());
        this.log.info((CharSequence)"Starting container");
        dockerClient.startContainerCmd(containerId).exec();
        String buildCommand = this.getCommand();
        String[] command = new String[]{"sh", "-c", buildCommand};
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withCmd(command).exec();
        this.log.info((CharSequence)("Running the following command: " + buildCommand));
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        TeeOutputStream tee = new TeeOutputStream(stdout, System.out);
        try {
            ExecStartResultCallback a = (ExecStartResultCallback)((ExecStartResultCallback)dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)tee, (OutputStream)System.err))).awaitCompletion();
            this.validateOutput(stdout.toString());
            this.zip(this.m.isCreateZip(), this.m.getBaseDir());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stdout.flush();
                stdout.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            dockerClient.stopContainerCmd(containerId).exec();
            dockerClient.removeContainerCmd(containerId).exec();
        }
    }
}

