/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.nativeimage.helper;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.HostConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class DockerHelper {
    private Log log;

    public DockerHelper(Log log) {
        this.log = log;
    }

    public List<String> copiedEnvVariables(List<String> envVariables) {
        ArrayList<String> newEnvVariables = new ArrayList<String>();
        envVariables.forEach(v -> {
            if (v.split("=").length == 2) {
                newEnvVariables.add((String)v);
            } else {
                String toCopy = System.getenv(v);
                newEnvVariables.add(v + "=" + toCopy);
            }
        });
        return newEnvVariables;
    }

    public String createContainer(DockerClient docker, File baseDir, List<String> envVariables, String dockerImage) throws MojoExecutionException {
        ContainerCreation containerCreation;
        HostConfig.Bind bind = HostConfig.Bind.from((String)baseDir.getAbsolutePath()).to("/working").build();
        this.log.info((CharSequence)("Mounting folder: " + baseDir.getAbsolutePath() + "to /working"));
        HostConfig hostConfig = HostConfig.builder().appendBinds(new HostConfig.Bind[]{bind}).build();
        this.log.info((CharSequence)"Creating container configuration");
        ContainerConfig containerConfig = ContainerConfig.builder().hostConfig(hostConfig).image(dockerImage).addVolume("graal").env(this.copiedEnvVariables(envVariables)).cmd(new String[]{"sh", "-c", "while :; do sleep 1; done"}).build();
        try {
            this.log.info((CharSequence)"Docker creating container configuration");
            containerCreation = docker.createContainer(containerConfig);
        }
        catch (Exception e) {
            docker.close();
            throw new MojoExecutionException(e.getMessage());
        }
        String id = containerCreation.id();
        this.log.info((CharSequence)("Created container with id: " + id));
        return id;
    }
}

