/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.nativeimage.commands;

import be.cloudway.gramba.nativeimage.builder.CommandStringBuilder;
import be.cloudway.gramba.nativeimage.commands.BaseCommand;
import be.cloudway.gramba.nativeimage.commands.OptionalCommands;
import be.cloudway.gramba.nativeimage.commands.TestingCommand;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class BuildCommand {
    private final Log log;
    private final CommandStringBuilder commandStringBuilder = new CommandStringBuilder();

    public BuildCommand(Log logger) {
        this.log = logger;
    }

    public String getCommand(List<String> delayedClasses, List<String> injectionFiles, File outputDirectory, List<String> additionalOptions, String jarName, List<String> testFiles, boolean skipBuild) {
        if (!skipBuild) {
            this.commandStringBuilder.append(BaseCommand.getCommand());
            this.getAdditionalOptions(additionalOptions);
            this.commandStringBuilder.append(OptionalCommands.getCommand(delayedClasses, injectionFiles, outputDirectory));
            this.getBuildAndCopyCommands(jarName);
        }
        this.commandStringBuilder.append(TestingCommand.getCommand(testFiles, skipBuild));
        return this.commandStringBuilder.build();
    }

    public void getAdditionalOptions(List<String> additionalOptions) {
        if (additionalOptions != null && additionalOptions.size() > 0) {
            this.commandStringBuilder.append(" ");
            this.commandStringBuilder.append(String.join((CharSequence)" ", additionalOptions));
        }
    }

    public void getBuildAndCopyCommands(String jarname) {
        this.commandStringBuilder.appendNoSpace(" -jar /working/target/").appendNoSpace(jarname).append(".jar && echo '-- BUILD SUCCESSFUL --'");
        this.commandStringBuilder.close().appendNoSpace("mv ./").append(jarname).append("/working/target/function");
        this.commandStringBuilder.close().append("chmod 755 /working/target/function");
    }
}

