/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.gramba.nativeimage;

import be.cloudway.gramba.nativeimage.NativeImageMain;
import be.cloudway.gramba.nativeimage.commands.BuildCommand;
import be.cloudway.gramba.nativeimage.helper.DockerHelper;
import be.cloudway.gramba.nativeimage.helper.ZipHelper;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.messages.ExecCreation;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class NativeImageHandler {
    private BuildCommand commandBuilder;
    private DockerHelper dockerHelper;
    private final NativeImageMain m;
    private Log log;

    public NativeImageHandler(Log log, NativeImageMain main) {
        this.log = log;
        this.commandBuilder = new BuildCommand(log);
        this.dockerHelper = new DockerHelper(log);
        this.m = main;
    }

    private void zip(boolean createZip, File baseDir) throws MojoFailureException {
        if (!createZip) {
            return;
        }
        this.log.info((CharSequence)"Creating function.zip file");
        ZipHelper.toFunctionZip(baseDir.getAbsolutePath() + "/target/function", baseDir + "/target/function.zip");
    }

    private void validateOutput(String output) throws MojoFailureException {
        if (!output.contains("-- BUILD SUCCESSFUL --")) {
            throw new MojoFailureException("Build failed!");
        }
        if (!output.contains("-- TESTS SUCCESSFUL --") && !output.contains("-- NO TESTS --")) {
            throw new MojoFailureException("Tests failed!");
        }
    }

    private String getCommand() {
        return this.commandBuilder.getCommand(this.m.getDelayedClasses(), this.m.getInjectionFiles(), this.m.getOutputDirectory(), this.m.getAdditionalOptions(), this.m.getJarName(), this.m.getTestFiles(), this.m.isSkipBuild());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws MojoExecutionException {
        DefaultDockerClient docker = null;
        String id = null;
        try {
            docker = DefaultDockerClient.fromEnv().build();
            id = this.dockerHelper.createContainer((DockerClient)docker, this.m.getBaseDir(), this.m.getEnvVariables(), this.m.getDockerImage());
            this.log.info((CharSequence)"Starting container");
            docker.startContainer(id);
            this.log.info((CharSequence)("Starting build of " + this.m.getJarName() + " this can take some time!"));
            String buildCommand = this.getCommand();
            this.log.info((CharSequence)("Running the following command --- " + buildCommand));
            String[] command = new String[]{"sh", "-c", buildCommand};
            ExecCreation execCreation = docker.execCreate(id, command, new DockerClient.ExecCreateParam[]{DockerClient.ExecCreateParam.attachStdout(), DockerClient.ExecCreateParam.attachStderr()});
            LogStream output = docker.execStart(execCreation.id(), new DockerClient.ExecStartParameter[0]);
            String execOutput = output.readFully();
            this.log.info((CharSequence)execOutput);
            this.validateOutput(execOutput);
            this.zip(this.m.isCreateZip(), this.m.getBaseDir());
            if (id == null) return;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (id == null) throw throwable;
                try {
                    docker.killContainer(id);
                    docker.removeContainer(id);
                    throw throwable;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new MojoExecutionException(e2.getMessage());
                }
                finally {
                    docker.close();
                    this.log.info((CharSequence)"Finished creating and zipping of native-image");
                }
            }
        }
        try {
            docker.killContainer(id);
            docker.removeContainer(id);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            docker.close();
            this.log.info((CharSequence)"Finished creating and zipping of native-image");
        }
    }
}

