/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.easy.reflection.dependency.configuration;

import be.cloudway.gramba.annotations.GrambaConfigurationTarget;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoFailureException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ConfigurationLoader {
    private String pack;
    private List<Object> configurationClasses = new ArrayList<Object>();

    public ConfigurationLoader(String pack) {
        this.pack = pack;
    }

    public ConfigurationLoader() {
        this.pack = "be.cloudway.gramba.configuration";
    }

    public void load() throws MojoFailureException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.addUrls(ClasspathHelper.forPackage((String)this.pack, (ClassLoader[])new ClassLoader[0]));
        if (this.pack == null) {
            configurationBuilder.addUrls(ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{classLoader}));
        }
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set classes = reflections.getTypesAnnotatedWith(GrambaConfigurationTarget.class);
        System.out.println("Found configuration files: " + classes.size() + " for package: " + this.pack);
        for (Class v : classes) {
            try {
                Constructor<?> ctor = v.getConstructors()[0];
                ctor.setAccessible(true);
                this.configurationClasses.add(ctor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public List<Object> getConfigurationClasses() {
        return this.configurationClasses;
    }
}

