/*
 * Decompiled with CFR 0.152.
 */
package be.cloudway.easy.reflection;

import be.cloudway.easy.reflection.dependency.configuration.proxy.ProxyConfigurationInterface;
import be.cloudway.easy.reflection.helpers.ReflectionJsonFileWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class ProxyConfigurationHandler {
    private List<List<String>> proxyConfigurationList = new ArrayList<List<String>>();

    public void handle(List<Object> configurationList, File outputDirectory) throws MojoExecutionException {
        this.proxyConfigurationList.clear();
        configurationList.forEach(this::handleEntry);
        ReflectionJsonFileWriter.writeFile(outputDirectory, this.proxyConfigurationList, "proxies.json");
    }

    private void handleEntry(Object configuration) {
        if (!(configuration instanceof ProxyConfigurationInterface)) {
            return;
        }
        ProxyConfigurationInterface proxyConfigurationInterface = (ProxyConfigurationInterface)configuration;
        System.out.println(proxyConfigurationInterface.getClass().getName());
        List<List<String>> proxyConfiguration = proxyConfigurationInterface.proxyConfiguration(new ArrayList<List<String>>());
        if (proxyConfiguration == null) {
            return;
        }
        this.proxyConfigurationList.addAll(proxyConfiguration);
    }
}

