/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.simplemail;

import be.ceau.simplemail.Mail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static final Logger logger = LoggerFactory.getLogger(Mailer.class);
    private final String smtpHost;
    private final Collection<InternetAddress> bccs;

    public Mailer(String smtp) {
        this(smtp, null);
    }

    public Mailer(String smtp, Collection<String> bccs) {
        if (smtp == null || smtp.trim().length() == 0) {
            throw new IllegalArgumentException("smtp argument can not be blank");
        }
        this.smtpHost = smtp;
        if (bccs == null) {
            this.bccs = Collections.emptyList();
        } else {
            ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
            for (String bcc : bccs) {
                try {
                    list.add(new InternetAddress(bcc));
                }
                catch (AddressException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            this.bccs = Collections.unmodifiableList(list);
        }
    }

    public boolean send(Mail mail) {
        if (mail == null || !mail.isValid()) {
            throw new IllegalArgumentException("Mail argument is null or not valid");
        }
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", this.smtpHost);
        Session session = Session.getInstance((Properties)properties);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)mail.getFrom());
            message.addRecipient(Message.RecipientType.TO, (Address)mail.getTo());
            for (InternetAddress cc : mail.getCcs()) {
                message.addRecipient(MimeMessage.RecipientType.CC, (Address)cc);
            }
            for (InternetAddress bcc : mail.getBccs()) {
                message.addRecipient(MimeMessage.RecipientType.BCC, (Address)bcc);
            }
            if (this.bccs != null) {
                for (InternetAddress bcc : this.bccs) {
                    message.addRecipient(MimeMessage.RecipientType.BCC, (Address)bcc);
                }
            }
            message.setSubject(mail.getSubject(), "UTF-8");
            if (mail.getHtml() == null) {
                message.setText(mail.getTxt(), "UTF-8", "plain");
            } else {
                MimeBodyPart txtPart = new MimeBodyPart();
                txtPart.setContent((Object)mail.getTxt(), "text/plain; charset=UTF-8");
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)mail.getHtml(), "text/html; charset=UTF-8");
                MimeMultipart multipart = new MimeMultipart("alternative");
                multipart.addBodyPart((BodyPart)txtPart);
                multipart.addBodyPart((BodyPart)htmlPart);
                MimeBodyPart wrapper = new MimeBodyPart();
                wrapper.setContent((Object)multipart, "text/alternative");
                MimeMultipart mwrapper = new MimeMultipart("mixed");
                mwrapper.addBodyPart((BodyPart)wrapper);
                message.setContent((Multipart)mwrapper);
            }
            Transport.send((Message)message);
            logger.trace("send(Mail {}): success", (Object)mail);
            return true;
        }
        catch (SendFailedException e) {
            logger.error("send(Mail {})", (Object)mail, (Object)e);
            return false;
        }
        catch (MessagingException e) {
            logger.error("send(Mail {})", (Object)mail, (Object)e);
            return false;
        }
    }
}

