/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.simplemail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class Mail
implements Serializable {
    private static final long serialVersionUID = 201506201202L;
    private InternetAddress from;
    private InternetAddress to;
    private final List<InternetAddress> ccs = new ArrayList<InternetAddress>();
    private final List<InternetAddress> bccs = new ArrayList<InternetAddress>();
    private String subject;
    private String txt;
    private String html;

    public Mail from(InternetAddress from) {
        if (from == null) {
            throw new IllegalArgumentException("from argument can not be null");
        }
        this.from = from;
        return this;
    }

    public Mail from(String from) {
        this.from = this.convert(from);
        return this;
    }

    public Mail to(InternetAddress to) {
        if (to == null) {
            throw new IllegalArgumentException("to argument can not be null");
        }
        this.to = to;
        return this;
    }

    public Mail to(String to) {
        this.to = this.convert(to);
        return this;
    }

    public Mail withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Mail withText(String txt) {
        this.txt = txt;
        return this;
    }

    public Mail withHtml(String html) {
        this.html = html;
        return this;
    }

    public Mail addCc(String cc) {
        this.ccs.add(this.convert(cc));
        return this;
    }

    public Mail addCc(InternetAddress cc) {
        if (cc == null) {
            throw new IllegalArgumentException("cc argument can not be null");
        }
        this.ccs.add(cc);
        return this;
    }

    public Mail addBcc(String bcc) {
        this.bccs.add(this.convert(bcc));
        return this;
    }

    public Mail addBcc(InternetAddress bcc) {
        if (bcc == null) {
            throw new IllegalArgumentException("bcc argument can not be null");
        }
        this.bccs.add(bcc);
        return this;
    }

    private InternetAddress convert(String email) {
        try {
            return new InternetAddress(email);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(email + " is not a valid email address");
        }
    }

    boolean isValid() {
        return this.from != null && this.to != null && (this.txt != null || this.html != null);
    }

    public String toString() {
        return "Mail [from=" + this.from + ", to=" + this.to + ", ccs=" + this.ccs + ", bccs=" + this.bccs + ", subject=" + this.subject + ", txt=" + this.txt + ", html=" + this.html + "]";
    }

    InternetAddress getFrom() {
        return this.from;
    }

    InternetAddress getTo() {
        return this.to;
    }

    List<InternetAddress> getCcs() {
        return this.ccs;
    }

    List<InternetAddress> getBccs() {
        return this.bccs;
    }

    String getSubject() {
        return this.subject;
    }

    String getTxt() {
        return this.txt;
    }

    String getHtml() {
        return this.html;
    }
}

