/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.simplemail;

import be.ceau.simplemail.Mail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static final Logger logger = LoggerFactory.getLogger(Mailer.class);
    private final String smtpHost;
    private final InternetAddress from;
    private final List<InternetAddress> tos;
    private final List<InternetAddress> ccs;
    private final List<InternetAddress> bccs;

    public Mailer(String smtp) {
        if (smtp == null || smtp.trim().length() == 0) {
            throw new IllegalArgumentException("smtp argument can not be blank");
        }
        this.smtpHost = smtp;
        this.from = null;
        this.tos = Collections.emptyList();
        this.ccs = Collections.emptyList();
        this.bccs = Collections.emptyList();
    }

    private Mailer(Builder builder) {
        this.smtpHost = builder.smtp;
        this.from = builder.from;
        this.tos = Collections.unmodifiableList(new ArrayList(builder.tos));
        this.ccs = Collections.unmodifiableList(new ArrayList(builder.ccs));
        this.bccs = Collections.unmodifiableList(new ArrayList(builder.bccs));
    }

    public static Builder builder(String smtp) {
        return new Builder(smtp);
    }

    public boolean send(Mail mail) {
        if (mail == null) {
            throw new IllegalArgumentException("Mail argument can not be null");
        }
        InternetAddress from = this.determineFrom(mail);
        if (!mail.hasTo()) {
            throw new IllegalArgumentException("Mail argument must have at least one 'to' address");
        }
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", this.smtpHost);
        Session session = Session.getInstance((Properties)properties);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)from);
            this.add(Message.RecipientType.TO, this.tos, message);
            this.add(Message.RecipientType.TO, mail.getTos(), message);
            this.add(Message.RecipientType.CC, this.ccs, message);
            this.add(Message.RecipientType.CC, mail.getCcs(), message);
            this.add(Message.RecipientType.BCC, this.bccs, message);
            this.add(Message.RecipientType.BCC, mail.getBccs(), message);
            if (mail.hasSubject()) {
                message.setSubject(mail.getSubject(), "UTF-8");
            }
            if (mail.hasTxt() && mail.hasHtml()) {
                MimeMultipart multipart = new MimeMultipart("alternative");
                multipart.addBodyPart(mail.getTxtBodyPart());
                multipart.addBodyPart(mail.getHtmlBodyPart());
                MimeBodyPart wrapper = new MimeBodyPart();
                wrapper.setContent((Object)multipart, "text/alternative");
                MimeMultipart mwrapper = new MimeMultipart("mixed");
                mwrapper.addBodyPart((BodyPart)wrapper);
                message.setContent((Multipart)mwrapper);
            } else if (mail.hasTxt()) {
                message.setText(mail.getTxt(), "UTF-8", "plain");
            } else if (mail.hasHtml()) {
                message.setText(mail.getHtml(), "UTF-8", "html");
            } else {
                message.setText("", "UTF-8", "plain");
            }
            Transport.send((Message)message);
            logger.trace("send(Mail {}): success", (Object)mail);
            return true;
        }
        catch (SendFailedException e) {
            logger.error("send(Mail {})", (Object)mail, (Object)e);
            return false;
        }
        catch (MessagingException e) {
            logger.error("send(Mail {})", (Object)mail, (Object)e);
            return false;
        }
    }

    private void add(Message.RecipientType type, Collection<? extends Address> addresses, MimeMessage message) throws MessagingException {
        for (Address address : addresses) {
            message.addRecipient(type, address);
        }
    }

    private InternetAddress determineFrom(Mail mail) {
        if (mail.hasFrom()) {
            if (this.from != null) {
                logger.info("both Mail argument and this Mailer instance have 'from' email address - using " + mail.getFrom());
            }
            return mail.getFrom();
        }
        if (this.from != null) {
            return this.from;
        }
        throw new IllegalStateException("this Mailer instance has no default 'from' address and the Mail argument does not provide one");
    }

    static InternetAddress convert(String email) {
        try {
            return new InternetAddress(email);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(email + " is a wrongly formatted address");
        }
    }

    public static class Builder {
        private final String smtp;
        private InternetAddress from;
        private final List<InternetAddress> tos = new ArrayList<InternetAddress>();
        private final List<InternetAddress> ccs = new ArrayList<InternetAddress>();
        private final List<InternetAddress> bccs = new ArrayList<InternetAddress>();

        private Builder(String smtp) {
            this.smtp = smtp;
        }

        public Builder from(InternetAddress from) {
            if (from == null) {
                throw new IllegalArgumentException("from argument can not be null");
            }
            this.from = from;
            return this;
        }

        public Builder from(String from) {
            this.from = Mailer.convert(from);
            return this;
        }

        public Builder to(InternetAddress to) {
            if (to == null) {
                throw new IllegalArgumentException("to argument can not be null");
            }
            this.tos.add(to);
            return this;
        }

        public Builder to(String to) {
            this.tos.add(Mailer.convert(to));
            return this;
        }

        public Builder cc(InternetAddress cc) {
            if (cc == null) {
                throw new IllegalArgumentException("cc argument can not be null");
            }
            this.ccs.add(cc);
            return this;
        }

        public Builder cc(String cc) {
            this.ccs.add(Mailer.convert(cc));
            return this;
        }

        public Builder bcc(InternetAddress bcc) {
            if (bcc == null) {
                throw new IllegalArgumentException("bcc argument can not be null");
            }
            this.bccs.add(bcc);
            return this;
        }

        public Builder bcc(String bcc) {
            this.bccs.add(Mailer.convert(bcc));
            return this;
        }

        public Mailer build() {
            return new Mailer(this);
        }
    }
}

