/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.simplemail;

import be.ceau.simplemail.Mailer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;

public class Mail
implements Serializable {
    private static final long serialVersionUID = 1438888844956L;
    private InternetAddress from;
    private final List<InternetAddress> tos = new ArrayList<InternetAddress>();
    private final List<InternetAddress> ccs = new ArrayList<InternetAddress>();
    private final List<InternetAddress> bccs = new ArrayList<InternetAddress>();
    private String subject;
    private String txt;
    private String html;

    public Mail from(InternetAddress from) {
        if (from == null) {
            throw new IllegalArgumentException("from argument can not be null");
        }
        this.from = from;
        return this;
    }

    public Mail from(String from) {
        this.from = Mailer.convert(from);
        return this;
    }

    public Mail to(InternetAddress to) {
        if (to == null) {
            throw new IllegalArgumentException("to argument can not be null");
        }
        this.tos.add(to);
        return this;
    }

    public Mail to(String to) {
        this.tos.add(Mailer.convert(to));
        return this;
    }

    public Mail cc(InternetAddress cc) {
        if (cc == null) {
            throw new IllegalArgumentException("cc argument can not be null");
        }
        this.ccs.add(cc);
        return this;
    }

    public Mail cc(String cc) {
        this.ccs.add(Mailer.convert(cc));
        return this;
    }

    public Mail bcc(InternetAddress bcc) {
        if (bcc == null) {
            throw new IllegalArgumentException("bcc argument can not be null");
        }
        this.bccs.add(bcc);
        return this;
    }

    public Mail bcc(String bcc) {
        this.bccs.add(Mailer.convert(bcc));
        return this;
    }

    public Mail withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Mail withText(String txt) {
        this.txt = txt;
        return this;
    }

    public Mail withHtml(String html) {
        this.html = html;
        return this;
    }

    public String toString() {
        return "Mail [from=" + this.from + ", tos=" + this.tos + ", ccs=" + this.ccs + ", bccs=" + this.bccs + ", subject=" + this.subject + ", txt=" + this.txt + ", html=" + this.html + "]";
    }

    InternetAddress getFrom() {
        return this.from;
    }

    boolean hasFrom() {
        return this.from != null;
    }

    List<InternetAddress> getTos() {
        return this.tos;
    }

    boolean hasTo() {
        return this.tos.size() > 0;
    }

    List<InternetAddress> getCcs() {
        return this.ccs;
    }

    List<InternetAddress> getBccs() {
        return this.bccs;
    }

    String getSubject() {
        return this.subject;
    }

    boolean hasSubject() {
        return this.subject != null;
    }

    boolean hasTxt() {
        return this.txt != null && !this.txt.isEmpty();
    }

    String getTxt() {
        return this.txt;
    }

    void setTxt(String txt) {
        this.txt = txt;
    }

    boolean hasHtml() {
        return this.html != null && !this.html.isEmpty();
    }

    String getHtml() {
        return this.html;
    }

    void setHtml(String html) {
        this.html = html;
    }

    BodyPart getTxtBodyPart() throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)this.txt, "text/plain; charset=UTF-8");
        return part;
    }

    BodyPart getHtmlBodyPart() throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)this.html, "text/html; charset=UTF-8");
        return part;
    }
}

