/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.itunesapi;

import be.ceau.itunesapi.http.Connector;
import be.ceau.itunesapi.http.URLConnector;
import be.ceau.itunesapi.request.Country;
import be.ceau.itunesapi.request.feedgenerator.FeedFormat;
import be.ceau.itunesapi.request.feedgenerator.FeedType;
import be.ceau.itunesapi.request.feedgenerator.MediaType;
import be.ceau.itunesapi.response.feedgenerator.Feed;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedGenerator
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(FeedGenerator.class);
    private static final long serialVersionUID = 1501610083087L;
    private static final String API_ENDPOINT = "https://rss.itunes.apple.com/api/v1/";
    private Country country = Country.UNITED_STATES;
    private MediaType mediaType = MediaType.APPLE_MUSIC;
    private FeedType feedType = FeedType.NEW_MUSIC;
    private String genre = "all";
    private int resultsLimit = 10;
    private boolean allowExplicit = true;
    private FeedFormat format = FeedFormat.JSON;

    public String getUrl() {
        return API_ENDPOINT + this.country.getIso().toLowerCase(Locale.ENGLISH) + '/' + this.mediaType.getCode() + '/' + this.feedType.getCode() + '/' + this.genre + '/' + this.resultsLimit + '/' + (this.allowExplicit ? "explicit" : "non-explicit") + '.' + this.format.getCode();
    }

    public Feed execute() {
        return this.execute(URLConnector.INSTANCE);
    }

    public Feed execute(Connector connector) {
        if (connector == null) {
            throw new IllegalArgumentException("connector can not be null");
        }
        FeedFormat chosenFormat = this.getFormat();
        this.setFormat(FeedFormat.JSON);
        String url = this.getUrl();
        this.setFormat(chosenFormat);
        try {
            String response = connector.get(url);
            logger.trace("{} -> {}", (Object)url, (Object)response);
            JsonNode json = Feed.READER.readTree(response).get("feed");
            return (Feed)Feed.READER.treeToValue((TreeNode)json, Feed.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Country getCountry() {
        return this.country;
    }

    public FeedGenerator setCountry(Country country) {
        if (country == null) {
            throw new IllegalArgumentException("country must be specified");
        }
        this.country = country;
        return this;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public FeedGenerator setMediaType(MediaType mediaType) {
        if (this.country == null) {
            throw new IllegalArgumentException("mediaType must be specified");
        }
        this.mediaType = mediaType;
        this.setFeedType(mediaType.getCompatibleFeedTypes().iterator().next());
        return this;
    }

    public FeedType getFeedType() {
        return this.feedType;
    }

    public FeedGenerator setFeedType(FeedType feedType) {
        if (feedType == null) {
            throw new IllegalArgumentException("feedType must be specified");
        }
        if (!this.mediaType.getCompatibleFeedTypes().contains((Object)feedType)) {
            throw new IllegalArgumentException("feedType must be compatible with mediaType");
        }
        this.feedType = feedType;
        return this;
    }

    public int getResultsLimit() {
        return this.resultsLimit;
    }

    public FeedGenerator setResultsLimit(int resultsLimit) {
        if (resultsLimit < 1) {
            throw new IllegalArgumentException("resultsLimit must be a positive integer");
        }
        this.resultsLimit = resultsLimit;
        return this;
    }

    public boolean isAllowExplicit() {
        return this.allowExplicit;
    }

    public FeedGenerator setAllowExplicit(boolean allowExplicit) {
        this.allowExplicit = allowExplicit;
        return this;
    }

    public FeedFormat getFormat() {
        return this.format;
    }

    public FeedGenerator setFormat(FeedFormat format) {
        this.format = format;
        return this;
    }
}

