/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.data.PolarData;
import be.ceau.chart.dataset.PolarDataset;
import be.ceau.chart.options.PolarOptions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class PolarChart
implements Chart {
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter().forType(PolarChart.class);
    private final String type = "polarArea";
    private PolarData data;
    private PolarOptions options;

    public static PolarData data() {
        return new PolarData();
    }

    public static PolarOptions options() {
        return new PolarOptions();
    }

    public PolarChart() {
    }

    public PolarChart(PolarData data) {
        this.data = data;
    }

    public PolarChart(PolarData data, PolarOptions options) {
        this.data = data;
        this.options = options;
    }

    public PolarData getData() {
        return this.data;
    }

    public PolarChart setData(PolarData data) {
        this.data = data;
        return this;
    }

    public PolarOptions getOptions() {
        return this.options;
    }

    public PolarChart setOptions(PolarOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public String getType() {
        return "polarArea";
    }

    @Override
    public String toJson() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDrawable() {
        for (PolarDataset dataset : this.data.getDatasets()) {
            if (dataset.getData().size() <= 1) continue;
            return true;
        }
        return false;
    }
}

