/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.data.DoughnutData;
import be.ceau.chart.options.DoughnutOptions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DoughnutChart
implements Chart {
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter().forType(DoughnutChart.class);
    private final String type = "doughnut";
    private DoughnutData data;
    private DoughnutOptions options;

    public DoughnutChart() {
    }

    public DoughnutChart(DoughnutData data, DoughnutOptions options) {
        this.data = data;
        this.options = options;
    }

    public DoughnutData getData() {
        return this.data;
    }

    public void setData(DoughnutData data) {
        this.data = data;
    }

    public DoughnutOptions getOptions() {
        return this.options;
    }

    public void setOptions(DoughnutOptions options) {
        this.options = options;
    }

    @Override
    public String getType() {
        return "doughnut";
    }

    @Override
    public String toJson() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDrawable() {
        return this.data != null && !this.data.getDatasets().isEmpty();
    }
}

