/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.data.BubbleData;
import be.ceau.chart.options.BubbleOptions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class BubbleChart
implements Chart {
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter().forType(BubbleChart.class);
    private final String type = "bubble";
    private BubbleData data;
    private BubbleOptions options;

    public BubbleChart() {
    }

    public BubbleChart(BubbleData data, BubbleOptions options) {
        this.data = data;
        this.options = options;
    }

    public BubbleData getData() {
        return this.data;
    }

    public void setData(BubbleData data) {
        this.data = data;
    }

    public BubbleOptions getOptions() {
        return this.options;
    }

    public void setOptions(BubbleOptions options) {
        this.options = options;
    }

    @Override
    public String getType() {
        return "bubble";
    }

    @Override
    public String toJson() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDrawable() {
        return this.data != null && !this.data.getDatasets().isEmpty();
    }
}

