/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.options;

import be.ceau.chart.Chart;
import be.ceau.chart.options.AnimationEasing;
import be.ceau.chart.options.BarOptions;
import be.ceau.chart.options.DoughnutOptions;
import be.ceau.chart.options.LineOptions;
import be.ceau.chart.options.PieOptions;
import be.ceau.chart.options.PolarOptions;
import be.ceau.chart.options.RadarOptions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Options {
    protected Boolean animation;
    protected Integer animationSteps;
    protected String animationEasing;
    protected Boolean showScale;
    protected Boolean scaleOverride;
    protected Integer scaleSteps;
    protected Integer scaleStepWidth;
    protected Integer scaleStartValue;
    protected String scaleLineColor;
    protected Integer scaleLineWidth;
    protected Boolean scaleShowLabels;
    protected String scaleLabel;
    protected Boolean scaleIntegersOnly;
    protected Boolean scaleBeginAtZero;
    protected String scaleFontFamily;
    protected Integer scaleFontSize;
    protected String scaleFontStyle;
    protected String scaleFontColor;
    protected Boolean responsive;
    protected Boolean maintainAspectRatio;
    protected Boolean showTooltips;
    protected List<String> tooltipEvents;
    protected String tooltipFillColor;
    protected String tooltipFontColor;
    protected String tooltipFontFamily;
    protected Integer tooltipFontSize;
    protected String tooltipFontStyle;
    protected String tooltipTitleFontColor;
    protected String tooltipTitleFontFamily;
    protected Integer tooltipTitleFontSize;
    protected String tooltipTitleFontStyle;
    protected Integer tooltipCaretSize;
    protected Integer tooltipCornerRadius;
    protected String tooltipTemplate;
    protected Integer tooltipXOffset;
    protected Integer tooltipXPadding;
    protected Integer tooltipYPadding;
    protected String multiTooltipTemplate;
    protected String legendTemplate;

    public static Options forType(Chart.Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Chart.Type argument can not be null");
        }
        switch (type) {
            case BAR: {
                return BarOptions.defaultInstance();
            }
            case DOUGHNUT: {
                return DoughnutOptions.defaultInstance();
            }
            case LINE: {
                return LineOptions.defaultInstance();
            }
            case PIE: {
                return PieOptions.defaultInstance();
            }
            case POLAR: {
                return PolarOptions.defaultInstance();
            }
            case RADAR: {
                return RadarOptions.defaultInstance();
            }
        }
        throw new UnsupportedOperationException("Chart.Type " + String.valueOf((Object)type) + " is not supported");
    }

    public Boolean getAnimation() {
        return this.animation;
    }

    public void setAnimation(Boolean animation) {
        this.animation = animation;
    }

    public Integer getAnimationSteps() {
        return this.animationSteps;
    }

    public void setAnimationSteps(Integer animationSteps) {
        this.animationSteps = animationSteps;
    }

    public String getAnimationEasing() {
        return this.animationEasing;
    }

    public void setAnimationEasing(AnimationEasing animationEasing) {
        this.animationEasing = animationEasing == null ? null : animationEasing.toString();
    }

    public Boolean getShowScale() {
        return this.showScale;
    }

    public void setShowScale(Boolean showScale) {
        this.showScale = showScale;
    }

    public Boolean getScaleOverride() {
        return this.scaleOverride;
    }

    public void setScaleOverride(Boolean scaleOverride) {
        this.scaleOverride = scaleOverride;
    }

    public Integer getScaleSteps() {
        return this.scaleSteps;
    }

    public void setScaleSteps(Integer scaleSteps) {
        this.scaleSteps = scaleSteps;
    }

    public Integer getScaleStepWidth() {
        return this.scaleStepWidth;
    }

    public void setScaleStepWidth(Integer scaleStepWidth) {
        this.scaleStepWidth = scaleStepWidth;
    }

    public Integer getScaleStartValue() {
        return this.scaleStartValue;
    }

    public void setScaleStartValue(Integer scaleStartValue) {
        this.scaleStartValue = scaleStartValue;
    }

    public String getScaleLineColor() {
        return this.scaleLineColor;
    }

    public void setScaleLineColor(String scaleLineColor) {
        this.scaleLineColor = scaleLineColor;
    }

    public Integer getScaleLineWidth() {
        return this.scaleLineWidth;
    }

    public void setScaleLineWidth(Integer scaleLineWidth) {
        this.scaleLineWidth = scaleLineWidth;
    }

    public Boolean getScaleShowLabels() {
        return this.scaleShowLabels;
    }

    public void setScaleShowLabels(Boolean scaleShowLabels) {
        this.scaleShowLabels = scaleShowLabels;
    }

    public String getScaleLabel() {
        return this.scaleLabel;
    }

    public void setScaleLabel(String scaleLabel) {
        this.scaleLabel = scaleLabel;
    }

    public Boolean getScaleIntegersOnly() {
        return this.scaleIntegersOnly;
    }

    public void setScaleIntegersOnly(Boolean scaleIntegersOnly) {
        this.scaleIntegersOnly = scaleIntegersOnly;
    }

    public Boolean getScaleBeginAtZero() {
        return this.scaleBeginAtZero;
    }

    public void setScaleBeginAtZero(Boolean scaleBeginAtZero) {
        this.scaleBeginAtZero = scaleBeginAtZero;
    }

    public String getScaleFontFamily() {
        return this.scaleFontFamily;
    }

    public void setScaleFontFamily(String scaleFontFamily) {
        this.scaleFontFamily = scaleFontFamily;
    }

    public Integer getScaleFontSize() {
        return this.scaleFontSize;
    }

    public void setScaleFontSize(Integer scaleFontSize) {
        this.scaleFontSize = scaleFontSize;
    }

    public String getScaleFontStyle() {
        return this.scaleFontStyle;
    }

    public void setScaleFontStyle(String scaleFontStyle) {
        this.scaleFontStyle = scaleFontStyle;
    }

    public String getScaleFontColor() {
        return this.scaleFontColor;
    }

    public void setScaleFontColor(String scaleFontColor) {
        this.scaleFontColor = scaleFontColor;
    }

    public Boolean getResponsive() {
        return this.responsive;
    }

    public void setResponsive(Boolean responsive) {
        this.responsive = responsive;
    }

    public Boolean getMaintainAspectRatio() {
        return this.maintainAspectRatio;
    }

    public void setMaintainAspectRatio(Boolean maintainAspectRatio) {
        this.maintainAspectRatio = maintainAspectRatio;
    }

    public Boolean getShowTooltips() {
        return this.showTooltips;
    }

    public void setShowTooltips(Boolean showTooltips) {
        this.showTooltips = showTooltips;
    }

    public List<String> getTooltipEvents() {
        if (this.tooltipEvents == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.tooltipEvents);
    }

    public void setTooltipEvents(List<String> tooltipEvents) {
        this.tooltipEvents = new ArrayList<String>();
        if (tooltipEvents != null) {
            this.tooltipEvents.addAll(tooltipEvents);
        }
    }

    public String getTooltipFillColor() {
        return this.tooltipFillColor;
    }

    public void setTooltipFillColor(String tooltipFillColor) {
        this.tooltipFillColor = tooltipFillColor;
    }

    public String getTooltipFontFamily() {
        return this.tooltipFontFamily;
    }

    public void setTooltipFontFamily(String tooltipFontFamily) {
        this.tooltipFontFamily = tooltipFontFamily;
    }

    public Integer getTooltipFontSize() {
        return this.tooltipFontSize;
    }

    public void setTooltipFontSize(Integer tooltipFontSize) {
        this.tooltipFontSize = tooltipFontSize;
    }

    public String getTooltipFontStyle() {
        return this.tooltipFontStyle;
    }

    public void setTooltipFontStyle(String tooltipFontStyle) {
        this.tooltipFontStyle = tooltipFontStyle;
    }

    public String getTooltipFontColor() {
        return this.tooltipFontColor;
    }

    public void setTooltipFontColor(String tooltipFontColor) {
        this.tooltipFontColor = tooltipFontColor;
    }

    public String getTooltipTitleFontFamily() {
        return this.tooltipTitleFontFamily;
    }

    public void setTooltipTitleFontFamily(String tooltipTitleFontFamily) {
        this.tooltipTitleFontFamily = tooltipTitleFontFamily;
    }

    public Integer getTooltipTitleFontSize() {
        return this.tooltipTitleFontSize;
    }

    public void setTooltipTitleFontSize(Integer tooltipTitleFontSize) {
        this.tooltipTitleFontSize = tooltipTitleFontSize;
    }

    public String getTooltipTitleFontStyle() {
        return this.tooltipTitleFontStyle;
    }

    public void setTooltipTitleFontStyle(String tooltipTitleFontStyle) {
        this.tooltipTitleFontStyle = tooltipTitleFontStyle;
    }

    public String getTooltipTitleFontColor() {
        return this.tooltipTitleFontColor;
    }

    public void setTooltipTitleFontColor(String tooltipTitleFontColor) {
        this.tooltipTitleFontColor = tooltipTitleFontColor;
    }

    public Integer getTooltipYPadding() {
        return this.tooltipYPadding;
    }

    public void setTooltipYPadding(Integer tooltipYPadding) {
        this.tooltipYPadding = tooltipYPadding;
    }

    public Integer getTooltipXPadding() {
        return this.tooltipXPadding;
    }

    public void setTooltipXPadding(Integer tooltipXPadding) {
        this.tooltipXPadding = tooltipXPadding;
    }

    public Integer getTooltipCaretSize() {
        return this.tooltipCaretSize;
    }

    public void setTooltipCaretSize(Integer tooltipCaretSize) {
        this.tooltipCaretSize = tooltipCaretSize;
    }

    public Integer getTooltipCornerRadius() {
        return this.tooltipCornerRadius;
    }

    public void setTooltipCornerRadius(Integer tooltipCornerRadius) {
        this.tooltipCornerRadius = tooltipCornerRadius;
    }

    public Integer getTooltipXOffset() {
        return this.tooltipXOffset;
    }

    public void setTooltipXOffset(Integer tooltipXOffset) {
        this.tooltipXOffset = tooltipXOffset;
    }

    public String getTooltipTemplate() {
        return this.tooltipTemplate;
    }

    public void setTooltipTemplate(String tooltipTemplate) {
        this.tooltipTemplate = tooltipTemplate;
    }

    public String getMultiTooltipTemplate() {
        return this.multiTooltipTemplate;
    }

    public void setMultiTooltipTemplate(String multiTooltipTemplate) {
        this.multiTooltipTemplate = multiTooltipTemplate;
    }

    public String getLegendTemplate() {
        return this.legendTemplate;
    }

    public void setLegendTemplate(String legendTemplate) {
        this.legendTemplate = legendTemplate;
    }

    public abstract Chart.Type getChartType();
}

