/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.data;

import be.ceau.chart.data.Data;
import be.ceau.chart.data.DataSet;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSetData
implements Data {
    @JsonProperty
    private final List<String> labels;
    @JsonProperty
    private final List<DataSet> datasets;

    public DataSetData(List<String> labels, List<DataSet> datasets) {
        if (labels == null || datasets == null) {
            throw new IllegalArgumentException("neither argument can not be null");
        }
        for (DataSet dataset : datasets) {
            if (dataset.getDataLength() == labels.size()) continue;
            throw new IllegalArgumentException("number of X-axis labels does not match number of datapoints in at least one dataset");
        }
        this.labels = Collections.unmodifiableList(new ArrayList<String>(labels));
        this.datasets = Collections.unmodifiableList(new ArrayList<DataSet>(datasets));
    }
}

