/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.data;

import be.ceau.chart.color.Colors;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class DataSet {
    private final String label;
    private final String fillColor;
    private final String strokeColor;
    private final String pointColor;
    private final String pointStrokeColor;
    private final String pointHighlightFill;
    private final String pointHighlightStroke;
    private final List<BigDecimal> data;
    @JsonIgnore
    private final BigDecimal min;
    @JsonIgnore
    private final BigDecimal max;

    public DataSet(String label, Colors colors, List<BigDecimal> data) {
        this.label = label;
        this.fillColor = colors.getFillColor().rgba();
        this.strokeColor = colors.getStrokeColor().rgba();
        this.pointColor = colors.getPointColor().rgba();
        this.pointStrokeColor = colors.getPointStrokeColor().rgba();
        this.pointHighlightFill = colors.getPointHighlightFill().rgba();
        this.pointHighlightStroke = colors.getPointHighlightStroke().rgba();
        this.data = Collections.unmodifiableList(new ArrayList<BigDecimal>(data));
        BigDecimal tempMin = new BigDecimal(Long.MAX_VALUE);
        BigDecimal tempMax = new BigDecimal(Long.MIN_VALUE);
        for (BigDecimal point : this.data) {
            if (point.compareTo(tempMin) < 0) {
                tempMin = point;
            }
            if (point.compareTo(tempMax) <= 0) continue;
            tempMax = point;
        }
        this.min = tempMin;
        this.max = tempMax;
    }

    public int getDataLength() {
        return this.data.size();
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public String getStrokeColor() {
        return this.strokeColor;
    }

    public String getPointColor() {
        return this.pointColor;
    }

    public String getPointStrokeColor() {
        return this.pointStrokeColor;
    }

    public String getPointHighlightFill() {
        return this.pointHighlightFill;
    }

    public String getPointHighlightStroke() {
        return this.pointHighlightStroke;
    }

    public List<BigDecimal> getData() {
        return this.data;
    }
}

