/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.color;

import be.ceau.chart.color.Color;

public class Colors {
    private Color fillColor;
    private Color strokeColor;
    private Color pointColor;
    private Color pointStrokeColor;
    private Color pointHighlightFill;
    private Color pointHighlightStroke;

    public Colors(Color fillColor, Color strokeColor, Color pointColor) {
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.pointColor = pointColor;
        this.pointStrokeColor = Color.WHITE;
        this.pointHighlightFill = Color.WHITE;
        this.pointHighlightStroke = pointColor;
    }

    public Colors(Color color) {
        this.fillColor = new Color(color, 0.5f);
        this.strokeColor = new Color(color, 1.0f);
        this.pointColor = new Color(color, 1.0f);
        this.pointStrokeColor = Color.WHITE;
        this.pointHighlightFill = Color.WHITE;
        this.pointHighlightStroke = this.pointColor;
    }

    public static Colors random() {
        return new Colors(Color.random());
    }

    public static Colors green() {
        return new Colors(new Color(0, 190, 0, 1.0f));
    }

    public static Colors red() {
        return new Colors(new Color(190, 0, 0, 1.0f));
    }

    public static Colors grayish() {
        return new Colors(new Color(217, 217, 217, 0.25f), new Color(107, 156, 217, 0.75f), new Color(107, 156, 217, 1.0f));
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            return Color.TRANSPARENT;
        }
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getStrokeColor() {
        if (this.strokeColor == null) {
            return Color.TRANSPARENT;
        }
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public Color getPointColor() {
        if (this.pointColor == null) {
            return Color.TRANSPARENT;
        }
        return this.pointColor;
    }

    public void setPointColor(Color pointColor) {
        this.pointColor = pointColor;
    }

    public Color getPointStrokeColor() {
        if (this.pointStrokeColor == null) {
            return Color.TRANSPARENT;
        }
        return this.pointStrokeColor;
    }

    public void setPointStrokeColor(Color pointStrokeColor) {
        this.pointStrokeColor = pointStrokeColor;
    }

    public Color getPointHighlightFill() {
        if (this.pointHighlightFill == null) {
            return Color.TRANSPARENT;
        }
        return this.pointHighlightFill;
    }

    public void setPointHighlightFill(Color pointHighlightFill) {
        this.pointHighlightFill = pointHighlightFill;
    }

    public Color getPointHighlightStroke() {
        if (this.pointHighlightStroke == null) {
            return Color.TRANSPARENT;
        }
        return this.pointHighlightStroke;
    }

    public void setPointHighlightStroke(Color pointHighlightStroke) {
        this.pointHighlightStroke = pointHighlightStroke;
    }
}

