/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.color;

import java.util.Random;

public class Color {
    public static final Color BLACK = new Color(0, 0, 0, 1.0f);
    public static final Color WHITE = new Color(255, 255, 255, 1.0f);
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0.0f);
    private static Random randomizer = new Random(System.nanoTime());
    private final int r;
    private final int g;
    private final int b;
    private final float a;

    public Color(int r, int g, int b, float alpha) {
        if (!(Color.isChannelWithinBounds(r) && Color.isChannelWithinBounds(g) && Color.isChannelWithinBounds(b) && Color.isAlphaWithinBounds(alpha))) {
            throw new IllegalArgumentException("at least one argument is not within bounds");
        }
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = alpha;
    }

    public Color(Color color, float alpha) {
        if (color == null) {
            throw new IllegalArgumentException("Color argument may not be null");
        }
        if (!Color.isAlphaWithinBounds(alpha)) {
            throw new IllegalArgumentException("alpha float argument is not within allowed bounds: allowed values are between 0 and 1 (inclusive), but value passed is " + alpha);
        }
        this.r = color.getR();
        this.g = color.getG();
        this.b = color.getB();
        this.a = alpha;
    }

    public static Color random() {
        int r = randomizer.nextInt(256);
        int g = randomizer.nextInt(256);
        int b = randomizer.nextInt(256);
        float a = randomizer.nextFloat();
        return new Color(r, g, b, a);
    }

    public static boolean isChannelWithinBounds(int channel) {
        return channel >= 0 && channel <= 255;
    }

    public static boolean isAlphaWithinBounds(float alpha) {
        return Float.compare(0.0f, alpha) <= 0 && Float.compare(1.0f, alpha) >= 0;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public float getA() {
        return this.a;
    }

    public String rgba() {
        return "rgba(" + this.r + "," + this.g + "," + this.b + "," + this.a + ")";
    }

    public String toString() {
        return this.rgba();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.a);
        result = 31 * result + this.b;
        result = 31 * result + this.g;
        result = 31 * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        if (Float.floatToIntBits(this.a) != Float.floatToIntBits(other.a)) {
            return false;
        }
        if (this.b != other.b) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        return this.r == other.r;
    }
}

