/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.ChartBuilder;
import be.ceau.chart.color.Colors;
import be.ceau.chart.data.DataSet;
import be.ceau.chart.data.DataSetData;
import be.ceau.chart.options.Options;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class DataSetChartBuilder
implements ChartBuilder {
    private final Chart.Type targetType;
    private final List<String> labels;
    private final List<List<BigDecimal>> datasetValues;
    private final List<Colors> datasetColors;
    private final List<String> datasetNames;
    private Options options;

    DataSetChartBuilder(Chart.Type targetType) {
        this.targetType = targetType;
        this.labels = new ArrayList<String>();
        this.datasetValues = new ArrayList<List<BigDecimal>>();
        this.datasetColors = new ArrayList<Colors>();
        this.datasetNames = new ArrayList<String>();
    }

    DataSetChartBuilder(Chart.Type targetType, Options options) {
        this.targetType = targetType;
        this.options = options;
        this.labels = new ArrayList<String>();
        this.datasetValues = new ArrayList<List<BigDecimal>>();
        this.datasetColors = new ArrayList<Colors>();
        this.datasetNames = new ArrayList<String>();
    }

    @Override
    public ChartBuilder setOptions(Options options) {
        if (options == null) {
            throw new IllegalArgumentException("Options argument may not be null");
        }
        if (!this.targetType.isCompatible(options)) {
            throw new IllegalArgumentException("Options argument is not of a type compatible with target Chart.Type " + (Object)((Object)this.targetType));
        }
        this.options = options;
        return this;
    }

    @Override
    public ChartBuilder addData(String label, BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("value argument may not be null");
        }
        if (label == null) {
            label = "";
        }
        if (this.datasetValues.isEmpty()) {
            this.newSeries("", Colors.random());
        }
        List<BigDecimal> valuelist = this.datasetValues.get(this.datasetValues.size() - 1);
        int index = valuelist.size();
        if (this.datasetValues.size() > 1) {
            if (valuelist.size() >= this.datasetValues.get(0).size()) {
                throw new IllegalArgumentException("It is not possible to add more values to a series than were added to a different series of the same chart");
            }
            if (!this.labels.get(index).equalsIgnoreCase(label)) {
                throw new IllegalArgumentException("The label does not match the label already present for this insert position. The label for position " + index + " is " + this.labels.get(index));
            }
        } else {
            this.labels.add(label);
        }
        valuelist.add(value);
        return this;
    }

    @Override
    public ChartBuilder addData(String label, int value) {
        return this.addData(label, new BigDecimal(value));
    }

    @Override
    public ChartBuilder addData(String label, double value) {
        return this.addData(label, new BigDecimal(String.valueOf(value)));
    }

    @Override
    public ChartBuilder newSeries(String name, Colors colors) {
        if (name == null) {
            name = String.valueOf(this.datasetValues.size() + 1);
        }
        if (colors == null) {
            colors = Colors.random();
        }
        this.datasetValues.add(new ArrayList());
        this.datasetColors.add(colors);
        this.datasetNames.add(name);
        return this;
    }

    @Override
    public Chart build() {
        ArrayList<DataSet> datasets = new ArrayList<DataSet>();
        for (int i = 0; i < this.datasetValues.size(); ++i) {
            datasets.add(new DataSet(this.datasetNames.get(i), this.datasetColors.get(i), this.datasetValues.get(i)));
        }
        DataSetData data = new DataSetData(this.labels, datasets);
        if (this.options == null) {
            this.options = Options.forType(this.targetType);
        }
        BigDecimal tempMax = new BigDecimal(Long.MIN_VALUE);
        for (DataSet dataset : datasets) {
            if (dataset.getMax().compareTo(tempMax) <= 0) continue;
            tempMax = dataset.getMax();
        }
        int step = this.calculateScaleStepWidth(tempMax.longValue());
        this.options.setScaleStepWidth(step);
        return new Chart(this.targetType, data, this.options);
    }

    private int calculateScaleStepWidth(long max) {
        int increment;
        long maximum = max;
        if (maximum < 10L) {
            return 1;
        }
        int magnitude = 0;
        while (maximum > 0L) {
            ++magnitude;
            maximum /= 10L;
        }
        maximum = max;
        int powerTen = BigInteger.TEN.pow(magnitude).intValue();
        for (int test = increment = powerTen / 10; test < powerTen; test += increment) {
            if (maximum >= (long)test) continue;
            return test / 10;
        }
        return powerTen / 10;
    }
}

