/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.ChartBuilder;
import be.ceau.chart.color.Color;
import be.ceau.chart.color.Colors;
import be.ceau.chart.data.DataPoint;
import be.ceau.chart.data.DataPointData;
import be.ceau.chart.options.Options;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class DataPointChartBuilder
implements ChartBuilder {
    private final Chart.Type targetType;
    private final List<String> labels;
    private final List<Color> colors;
    private final List<BigDecimal> values;
    private Options options;

    DataPointChartBuilder(Chart.Type targetType) {
        this.targetType = targetType;
        this.labels = new ArrayList<String>();
        this.colors = new ArrayList<Color>();
        this.values = new ArrayList<BigDecimal>();
    }

    DataPointChartBuilder(Chart.Type targetType, Options options) {
        this.targetType = targetType;
        this.options = options;
        this.labels = new ArrayList<String>();
        this.colors = new ArrayList<Color>();
        this.values = new ArrayList<BigDecimal>();
    }

    @Override
    public ChartBuilder setOptions(Options options) {
        if (options == null) {
            throw new IllegalArgumentException("Options argument may not be null");
        }
        if (!this.targetType.isCompatible(options)) {
            throw new IllegalArgumentException("Options argument is not of a type compatible with target Chart.Type " + (Object)((Object)this.targetType));
        }
        this.options = options;
        return this;
    }

    @Override
    public ChartBuilder addData(String label, BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("value argument may not be null");
        }
        if (label == null) {
            label = "";
        }
        this.labels.add(label);
        this.colors.add(Color.random());
        this.values.add(value);
        return this;
    }

    @Override
    public ChartBuilder addData(String label, int value) {
        return this.addData(label, new BigDecimal(value));
    }

    @Override
    public ChartBuilder addData(String label, double value) {
        return this.addData(label, new BigDecimal(String.valueOf(value)));
    }

    @Override
    public ChartBuilder newSeries(String name, Colors colors) {
        return this;
    }

    @Override
    public Chart build() {
        ArrayList<DataPoint> datapoints = new ArrayList<DataPoint>();
        for (int i = 0; i < this.values.size(); ++i) {
            datapoints.add(new DataPoint(this.labels.get(i), this.colors.get(i).rgba(), new Color(this.colors.get(i), 0.2f).rgba(), this.values.get(i)));
        }
        DataPointData data = new DataPointData(datapoints);
        if (this.options == null) {
            this.options = Options.forType(this.targetType);
        }
        return new Chart(this.targetType, data, this.options);
    }
}

