/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.ChartBuilder;
import be.ceau.chart.DataPointChartBuilder;
import be.ceau.chart.DataSetChartBuilder;
import be.ceau.chart.data.Data;
import be.ceau.chart.data.DataPointData;
import be.ceau.chart.data.DataSetData;
import be.ceau.chart.options.BarOptions;
import be.ceau.chart.options.DoughnutOptions;
import be.ceau.chart.options.LineOptions;
import be.ceau.chart.options.Options;
import be.ceau.chart.options.PieOptions;
import be.ceau.chart.options.PolarOptions;
import be.ceau.chart.options.RadarOptions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class Chart {
    @JsonProperty
    private final Type type;
    @JsonProperty
    private final Data data;
    @JsonProperty
    private final Options options;

    public static ChartBuilder builder(Type chartType) {
        if (chartType == null) {
            throw new IllegalArgumentException("Chart.Type argument can not be null");
        }
        if (Type.DATA_POINT_CHARTS.contains((Object)chartType)) {
            return new DataPointChartBuilder(chartType);
        }
        if (Type.DATA_SET_CHARTS.contains((Object)chartType)) {
            return new DataSetChartBuilder(chartType);
        }
        throw new UnsupportedOperationException("no ChartBuilder implementation registered for Chart.Type " + chartType.toString());
    }

    public static ChartBuilder builder(Options options) {
        if (options == null) {
            throw new IllegalArgumentException("Options argument can not be null");
        }
        Type type = Type.lookup(options);
        if (type == null) {
            throw new UnsupportedOperationException("no corresponding Chart Type found for Options argument of class " + options.getClass());
        }
        if (Type.DATA_POINT_CHARTS.contains((Object)type)) {
            return new DataPointChartBuilder(type, options);
        }
        if (Type.DATA_SET_CHARTS.contains((Object)type)) {
            return new DataSetChartBuilder(type, options);
        }
        throw new UnsupportedOperationException("no ChartBuilder implementation registered for Chart.Type " + type.toString());
    }

    Chart(Type type, Data data, Options options) {
        if (type == null) {
            throw new IllegalArgumentException("Chart.Type argument can not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data argument can not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Options argument can not be null");
        }
        if (!type.isCompatible(data)) {
            throw new IllegalArgumentException("Data object is not of proper class");
        }
        if (!type.isCompatible(options)) {
            throw new IllegalArgumentException("Options object is not of proper class");
        }
        this.type = type;
        this.data = data;
        this.options = options;
    }

    public Type getType() {
        return this.type;
    }

    public Data getData() {
        return this.data;
    }

    public Options getOptions() {
        return this.options;
    }

    public static enum Type {
        BAR(DataSetData.class, BarOptions.class),
        DOUGHNUT(DataPointData.class, DoughnutOptions.class),
        LINE(DataSetData.class, LineOptions.class),
        PIE(DataPointData.class, PieOptions.class),
        POLAR(DataPointData.class, PolarOptions.class),
        RADAR(DataSetData.class, RadarOptions.class);

        private final Class<? extends Data> dataClass;
        private final Class<? extends Options> optionsClass;
        private static final Set<Type> DATA_SET_CHARTS;
        private static final Set<Type> DATA_POINT_CHARTS;
        private static final Map<Class<? extends Options>, Type> OPTIONS_CLASSES;

        private Type(Class<? extends Data> dataClass, Class<? extends Options> optionsClass) {
            this.dataClass = dataClass;
            this.optionsClass = optionsClass;
        }

        public boolean isCompatible(Data data) {
            if (data == null) {
                return false;
            }
            return this.dataClass.isAssignableFrom(data.getClass());
        }

        public boolean isCompatible(Options options) {
            if (options == null) {
                return false;
            }
            return this.optionsClass.isAssignableFrom(options.getClass());
        }

        private static Type lookup(Options options) {
            if (options == null) {
                return null;
            }
            return OPTIONS_CLASSES.get(options.getClass());
        }

        static {
            HashMap<Class<? extends Options>, Type> optionsClasses = new HashMap<Class<? extends Options>, Type>();
            for (Type type : Type.values()) {
                optionsClasses.put(type.optionsClass, type);
            }
            OPTIONS_CLASSES = Collections.unmodifiableMap(optionsClasses);
            DATA_SET_CHARTS = Collections.unmodifiableSet(EnumSet.of(LINE, BAR, RADAR));
            DATA_POINT_CHARTS = Collections.unmodifiableSet(EnumSet.of(DOUGHNUT, PIE, POLAR));
        }
    }
}

