/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.jca;

import be.bosa.commons.eid.jca.BeIDKeyStoreParameter;
import be.bosa.commons.eid.jca.BeIDManagerFactoryParameters;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDX509KeyManager
extends X509ExtendedKeyManager {
    private static final Log LOG = LogFactory.getLog(BeIDX509KeyManager.class);
    private KeyStore keyStore;

    public BeIDX509KeyManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this(null);
    }

    public BeIDX509KeyManager(BeIDManagerFactoryParameters beIDSpec) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        BeIDKeyStoreParameter beIDKeyStoreParameter;
        LOG.debug((Object)"constructor");
        this.keyStore = KeyStore.getInstance("BeID");
        if (null == beIDSpec) {
            beIDKeyStoreParameter = null;
        } else {
            beIDKeyStoreParameter = new BeIDKeyStoreParameter();
            beIDKeyStoreParameter.setLocale(beIDSpec.getLocale());
            beIDKeyStoreParameter.setParentComponent(beIDSpec.getParentComponent());
            beIDKeyStoreParameter.setAutoRecovery(beIDSpec.getAutoRecovery());
            beIDKeyStoreParameter.setCardReaderStickiness(beIDSpec.getCardReaderStickiness());
        }
        this.keyStore.load(beIDKeyStoreParameter);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        LOG.debug((Object)"chooseClientAlias");
        for (String keyType : keyTypes) {
            LOG.debug((Object)("key type: " + keyType));
            if (!"RSA".equals(keyType)) continue;
            return "beid";
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        LOG.debug((Object)"chooseServerAlias");
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        LOG.debug((Object)("getCertificateChain: " + alias));
        if ("beid".equals(alias)) {
            Certificate[] certificateChain;
            try {
                certificateChain = this.keyStore.getCertificateChain("Authentication");
            }
            catch (KeyStoreException e) {
                LOG.error((Object)("BeID keystore error: " + e.getMessage()), (Throwable)e);
                return null;
            }
            X509Certificate[] x509CertificateChain = new X509Certificate[certificateChain.length];
            for (int idx = 0; idx < certificateChain.length; ++idx) {
                x509CertificateChain[idx] = (X509Certificate)certificateChain[idx];
            }
            return x509CertificateChain;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        LOG.debug((Object)"getClientAliases");
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        LOG.debug((Object)("getPrivateKey: " + alias));
        if ("beid".equals(alias)) {
            PrivateKey privateKey;
            try {
                privateKey = (PrivateKey)this.keyStore.getKey("Authentication", null);
            }
            catch (Exception e) {
                LOG.error((Object)("getKey error: " + e.getMessage()), (Throwable)e);
                return null;
            }
            return privateKey;
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        LOG.debug((Object)"getServerAliases");
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        LOG.debug((Object)"chooseEngineClientAlias");
        return super.chooseEngineClientAlias(keyType, issuers, engine);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        LOG.debug((Object)"chooseEngineServerAlias");
        return super.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

