/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.jca;

import be.bosa.commons.eid.jca.BeIDPrivateKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDSignature
extends SignatureSpi {
    private static final Log LOG = LogFactory.getLog(BeIDSignature.class);
    private static final Map<String, String> digestAlgos = new HashMap<String, String>();
    private final MessageDigest messageDigest;
    private BeIDPrivateKey privateKey;
    private Signature verifySignature;
    private final String signatureAlgorithm;
    private final ByteArrayOutputStream precomputedDigestOutputStream;

    BeIDSignature(String signatureAlgorithm) throws NoSuchAlgorithmException {
        LOG.debug((Object)("constructor: " + signatureAlgorithm));
        this.signatureAlgorithm = signatureAlgorithm;
        if (!digestAlgos.containsKey(signatureAlgorithm)) {
            LOG.error((Object)("no such algo: " + signatureAlgorithm));
            throw new NoSuchAlgorithmException(signatureAlgorithm);
        }
        String digestAlgo = digestAlgos.get(signatureAlgorithm);
        if (digestAlgo != null) {
            this.messageDigest = MessageDigest.getInstance(digestAlgo);
            this.precomputedDigestOutputStream = null;
        } else {
            LOG.debug((Object)"NONE message digest");
            this.messageDigest = null;
            this.precomputedDigestOutputStream = new ByteArrayOutputStream();
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        LOG.debug((Object)"engineInitVerify");
        if (null == this.verifySignature) {
            try {
                this.verifySignature = Signature.getInstance(this.signatureAlgorithm);
            }
            catch (NoSuchAlgorithmException nsaex) {
                throw new InvalidKeyException("no such algo: " + nsaex.getMessage(), nsaex);
            }
        }
        this.verifySignature.initVerify(publicKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        LOG.debug((Object)"engineInitSign");
        if (!(privateKey instanceof BeIDPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (BeIDPrivateKey)privateKey;
        if (null != this.messageDigest) {
            this.messageDigest.reset();
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
        if (null != this.verifySignature) {
            this.verifySignature.update(b);
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (null != this.messageDigest) {
            this.messageDigest.update(b, off, len);
        }
        if (null != this.precomputedDigestOutputStream) {
            this.precomputedDigestOutputStream.write(b, off, len);
        }
        if (null != this.verifySignature) {
            this.verifySignature.update(b, off, len);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        String digestAlgo;
        byte[] digestValue;
        LOG.debug((Object)"engineSign");
        if (null != this.messageDigest) {
            digestValue = this.messageDigest.digest();
            digestAlgo = this.messageDigest.getAlgorithm();
            if (this.signatureAlgorithm.endsWith("andMGF1")) {
                digestAlgo = digestAlgo + "-PSS";
            }
        } else if (null != this.precomputedDigestOutputStream) {
            digestValue = this.precomputedDigestOutputStream.toByteArray();
            digestAlgo = "NONE";
        } else {
            throw new SignatureException();
        }
        return this.privateKey.sign(digestValue, digestAlgo);
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        LOG.debug((Object)"engineVerify");
        if (null == this.verifySignature) {
            throw new SignatureException("initVerify required");
        }
        return this.verifySignature.verify(sigBytes);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    static {
        digestAlgos.put("SHA1withRSA", "SHA-1");
        digestAlgos.put("SHA224withRSA", "SHA-224");
        digestAlgos.put("SHA256withRSA", "SHA-256");
        digestAlgos.put("SHA384withRSA", "SHA-384");
        digestAlgos.put("SHA512withRSA", "SHA-512");
        digestAlgos.put("NONEwithRSA", null);
        digestAlgos.put("RIPEMD128withRSA", "RIPEMD128");
        digestAlgos.put("RIPEMD160withRSA", "RIPEMD160");
        digestAlgos.put("RIPEMD256withRSA", "RIPEMD256");
        digestAlgos.put("SHA1withRSAandMGF1", "SHA-1");
        digestAlgos.put("SHA256withRSAandMGF1", "SHA-256");
    }
}

