/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.jca;

import be.bosa.commons.eid.client.BeIDCard;
import be.bosa.commons.eid.client.BeIDCards;
import be.bosa.commons.eid.client.CancelledException;
import be.bosa.commons.eid.client.exception.BeIDException;
import java.security.SecureRandomSpi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDSecureRandom
extends SecureRandomSpi {
    private static final Log LOG = LogFactory.getLog(BeIDSecureRandom.class);
    private BeIDCard beIDCard;

    @Override
    protected void engineSetSeed(byte[] seed) {
        LOG.debug((Object)"engineSetSeed");
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        byte[] randomData;
        LOG.debug((Object)("engineNextBytes: " + bytes.length + " bytes"));
        BeIDCard beIDCard = this.getBeIDCard(false);
        try {
            try {
                randomData = beIDCard.getChallenge(bytes.length);
            }
            catch (Exception e) {
                beIDCard = this.getBeIDCard(true);
                randomData = beIDCard.getChallenge(bytes.length);
            }
        }
        catch (BeIDException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        System.arraycopy(randomData, 0, bytes, 0, bytes.length);
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] randomData;
        LOG.debug((Object)("engineGenerateSeed: " + numBytes + " bytes"));
        BeIDCard beIDCard = this.getBeIDCard(false);
        try {
            randomData = beIDCard.getChallenge(numBytes);
        }
        catch (BeIDException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return randomData;
    }

    private BeIDCard getBeIDCard(boolean autoRecover) {
        if (autoRecover) {
            this.beIDCard = null;
        }
        if (null != this.beIDCard) {
            return this.beIDCard;
        }
        BeIDCards beIDCards = new BeIDCards();
        try {
            this.beIDCard = beIDCards.getOneBeIDCard();
        }
        catch (CancelledException e) {
            throw new RuntimeException(e);
        }
        return this.beIDCard;
    }
}

