/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.jca;

import be.bosa.commons.eid.client.BeIDCard;
import be.bosa.commons.eid.client.FileType;
import be.bosa.commons.eid.client.impl.BeIDDigest;
import be.bosa.commons.eid.jca.BeIDKeyStore;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDPrivateKey
implements PrivateKey {
    private static final Log LOG = LogFactory.getLog(BeIDPrivateKey.class);
    private final FileType certificateFileType;
    private BeIDCard beIDCard;
    private final boolean logoff;
    private final boolean autoRecovery;
    private final BeIDKeyStore beIDKeyStore;
    private static final Map<String, BeIDDigest> beIDDigests = new HashMap<String, BeIDDigest>();
    private X509Certificate authenticationCertificate;

    public BeIDPrivateKey(FileType certificateFileType, BeIDCard beIDCard, boolean logoff, boolean autoRecovery, BeIDKeyStore beIDKeyStore) {
        LOG.debug((Object)("constructor: " + certificateFileType));
        this.certificateFileType = certificateFileType;
        this.beIDCard = beIDCard;
        this.logoff = logoff;
        this.autoRecovery = autoRecovery;
        this.beIDKeyStore = beIDKeyStore;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sign(byte[] digestValue, String digestAlgo) throws SignatureException {
        byte[] byArray;
        block15: {
            LOG.debug((Object)("auto recovery: " + this.autoRecovery));
            BeIDDigest beIDDigest = beIDDigests.get(digestAlgo);
            if (null == beIDDigest) {
                throw new SignatureException("unsupported algo: " + digestAlgo);
            }
            if (this.autoRecovery && this.authenticationCertificate == null) {
                try {
                    this.authenticationCertificate = this.beIDCard.getAuthenticationCertificate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                byArray = this.beIDCard.sign(digestValue, beIDDigest, this.certificateFileType, false);
                if (!this.logoff) break block15;
            }
            catch (Exception e) {
                byte[] byArray2;
                block16: {
                    try {
                        if (this.autoRecovery) {
                            X509Certificate newAuthenticationCertificate;
                            LOG.debug((Object)"trying to recover...");
                            this.beIDCard = this.beIDKeyStore.getBeIDCard(true);
                            if (null != this.authenticationCertificate && !this.authenticationCertificate.equals(newAuthenticationCertificate = this.beIDCard.getAuthenticationCertificate())) {
                                throw new SignatureException("different eID card");
                            }
                        }
                        byArray2 = this.beIDCard.sign(digestValue, beIDDigest, this.certificateFileType, false);
                        if (!this.logoff) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (this.logoff) {
                                this.beIDCard.logoff();
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            throw new SignatureException(ex);
                        }
                    }
                    this.beIDCard.logoff();
                }
                return byArray2;
            }
            this.beIDCard.logoff();
        }
        return byArray;
    }

    static {
        beIDDigests.put("SHA-1", BeIDDigest.SHA_1);
        beIDDigests.put("SHA-224", BeIDDigest.SHA_224);
        beIDDigests.put("SHA-256", BeIDDigest.SHA_256);
        beIDDigests.put("SHA-384", BeIDDigest.SHA_384);
        beIDDigests.put("SHA-512", BeIDDigest.SHA_512);
        beIDDigests.put("NONE", BeIDDigest.NONE);
        beIDDigests.put("RIPEMD128", BeIDDigest.RIPEMD_128);
        beIDDigests.put("RIPEMD160", BeIDDigest.RIPEMD_160);
        beIDDigests.put("RIPEMD256", BeIDDigest.RIPEMD_256);
        beIDDigests.put("SHA-1-PSS", BeIDDigest.SHA_1_PSS);
        beIDDigests.put("SHA-256-PSS", BeIDDigest.SHA_256_PSS);
    }
}

