/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.jca;

import be.bosa.commons.eid.jca.BeIDManagerFactoryParameters;
import be.bosa.commons.eid.jca.BeIDX509KeyManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDKeyManagerFactory
extends KeyManagerFactorySpi {
    private static final Log LOG = LogFactory.getLog(BeIDKeyManagerFactory.class);
    private BeIDManagerFactoryParameters beIDSpec;

    @Override
    protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        LOG.debug((Object)"engineInit(spec)");
        if (null == spec) {
            return;
        }
        if (!(spec instanceof BeIDManagerFactoryParameters)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.beIDSpec = (BeIDManagerFactoryParameters)spec;
    }

    @Override
    protected void engineInit(KeyStore keyStore, char[] password) {
        LOG.debug((Object)"engineInit(KeyStore,password)");
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        BeIDX509KeyManager beidKeyManager;
        LOG.debug((Object)"engineGetKeyManagers");
        try {
            beidKeyManager = new BeIDX509KeyManager(this.beIDSpec);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        return new KeyManager[]{beidKeyManager};
    }
}

