/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.dialogs;

import be.bosa.commons.eid.client.BeIDCard;
import be.bosa.commons.eid.client.CancelledException;
import be.bosa.commons.eid.client.OutOfCardsException;
import be.bosa.commons.eid.client.impl.LocaleManager;
import be.bosa.commons.eid.client.spi.BeIDCardsUI;
import be.bosa.commons.eid.dialogs.BeIDSelector;
import be.bosa.commons.eid.dialogs.JPanelWithInsets;
import be.bosa.commons.eid.dialogs.Messages;
import be.bosa.commons.eid.dialogs.Util;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.util.Collection;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class DefaultBeIDCardsUI
implements BeIDCardsUI {
    private final Component parentComponent;
    private Messages messages;
    private JFrame adviseFrame;
    private BeIDSelector selectionDialog;
    private Locale locale;

    public DefaultBeIDCardsUI() {
        this(null);
    }

    public DefaultBeIDCardsUI(Component parentComponent) {
        this(parentComponent, null);
    }

    public DefaultBeIDCardsUI(Component parentComponent, Messages messages) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new UnsupportedOperationException("DefaultBeIDCardsUI is a GUI and cannot run in a headless environment");
        }
        this.parentComponent = parentComponent;
        if (messages != null) {
            this.messages = messages;
            this.setLocale(messages.getLocale());
        } else {
            this.messages = Messages.getInstance(this.getLocale());
        }
    }

    public void adviseCardTerminalRequired() {
        this.showAdvise(this.messages.getMessage(Messages.MESSAGE_ID.CONNECT_READER), this.messages.getMessage(Messages.MESSAGE_ID.CONNECT_READER));
    }

    public void adviseBeIDCardRequired() {
        this.showAdvise(this.messages.getMessage(Messages.MESSAGE_ID.INSERT_CARD_QUESTION), this.messages.getMessage(Messages.MESSAGE_ID.INSERT_CARD_QUESTION));
    }

    public void adviseBeIDCardRemovalRequired() {
        this.showAdvise(this.messages.getMessage(Messages.MESSAGE_ID.REMOVE_CARD), this.messages.getMessage(Messages.MESSAGE_ID.REMOVE_CARD));
    }

    public BeIDCard selectBeIDCard(Collection<BeIDCard> availableCards) throws CancelledException, OutOfCardsException {
        try {
            this.selectionDialog = new BeIDSelector(this.parentComponent, "Select eID card", availableCards);
            BeIDCard beIDCard = this.selectionDialog.choose();
            return beIDCard;
        }
        finally {
            this.selectionDialog = null;
        }
    }

    public void adviseEnd() {
        if (null != this.adviseFrame) {
            this.adviseFrame.dispose();
            this.adviseFrame = null;
        }
    }

    private void showAdvise(String title, String message) {
        if (null != this.adviseFrame) {
            this.adviseEnd();
        }
        this.adviseFrame = new JFrame(title);
        JPanelWithInsets panel = new JPanelWithInsets(new Insets(10, 30, 10, 30));
        BoxLayout boxLayout = new BoxLayout(panel, 3);
        panel.setLayout(boxLayout);
        panel.add(new JLabel(message));
        this.adviseFrame.getContentPane().add(panel);
        this.adviseFrame.pack();
        if (this.parentComponent != null) {
            this.adviseFrame.setLocationRelativeTo(this.parentComponent);
        } else {
            Util.centerOnScreen(this.adviseFrame);
        }
        this.adviseFrame.setAlwaysOnTop(true);
        this.adviseFrame.setVisible(true);
    }

    public void eIDCardInsertedDuringSelection(BeIDCard card) {
        if (this.selectionDialog != null) {
            this.selectionDialog.addEIDCard(card);
        }
    }

    public void eIDCardRemovedDuringSelection(BeIDCard card) {
        if (this.selectionDialog != null) {
            this.selectionDialog.removeEIDCard(card);
        }
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        this.messages = Messages.getInstance(newLocale);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return LocaleManager.getLocale();
    }
}

