/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.dialogs;

import be.bosa.commons.eid.client.BeIDCard;
import be.bosa.commons.eid.client.CancelledException;
import be.bosa.commons.eid.client.FileType;
import be.bosa.commons.eid.client.OutOfCardsException;
import be.bosa.commons.eid.client.event.BeIDCardListener;
import be.bosa.commons.eid.consumer.Identity;
import be.bosa.commons.eid.consumer.text.Format;
import be.bosa.commons.eid.consumer.tlv.TlvParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class BeIDSelector {
    private JDialog dialog;
    private JPanel masterPanel;
    private DefaultListModel<ListData> listModel;
    private JList<ListData> list;
    private final Component parentComponent;
    private final ListData selectedListData;
    private final Map<BeIDCard, ListDataUpdater> updaters;
    private int identitiesbeingRead;
    private boolean outOfCards;

    public BeIDSelector(Component parentComponent, String title, Collection<BeIDCard> initialCards) {
        this.parentComponent = parentComponent;
        this.selectedListData = new ListData(null);
        this.updaters = new HashMap<BeIDCard, ListDataUpdater>();
        this.identitiesbeingRead = 0;
        this.outOfCards = false;
        this.initComponents(title);
        for (BeIDCard card : initialCards) {
            this.addEIDCard(card);
        }
        this.list.addMouseListener(new ListMouseAdapter());
    }

    public void addEIDCard(BeIDCard card) {
        ListData listData = new ListData(card);
        this.addToList(listData);
        ListDataUpdater listDataUpdater = new ListDataUpdater(this, listData);
        this.updaters.put(card, listDataUpdater);
        listDataUpdater.start();
    }

    public void removeEIDCard(BeIDCard card) {
        ListDataUpdater listDataUpdater = this.updaters.get(card);
        listDataUpdater.stop();
        this.updaters.remove(card);
        this.removeFromList(listDataUpdater.getListData());
    }

    public synchronized void startReadingIdentity() {
        ++this.identitiesbeingRead;
        this.notifyAll();
    }

    public synchronized void endReadingIdentity() {
        --this.identitiesbeingRead;
        this.repack();
        this.notifyAll();
    }

    public synchronized void waitUntilIdentitiesRead() {
        try {
            while (this.identitiesbeingRead > 0) {
                this.wait();
            }
        }
        catch (InterruptedException iex) {
            throw new RuntimeException("Interrupted", iex);
        }
    }

    public void stop() {
        for (ListDataUpdater updater : this.updaters.values()) {
            updater.stop();
        }
        for (ListDataUpdater updater : this.updaters.values()) {
            try {
                updater.join();
            }
            catch (InterruptedException iex) {
                return;
            }
        }
    }

    public BeIDCard choose() throws OutOfCardsException, CancelledException {
        this.waitUntilIdentitiesRead();
        if (this.parentComponent != null) {
            this.dialog.setLocationRelativeTo(this.parentComponent);
        } else {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.dialog.setLocation((screen.width - this.dialog.getSize().width) / 2, (screen.height - this.dialog.getSize().height) / 2);
        }
        this.dialog.setResizable(false);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.setVisible(true);
        if (this.outOfCards) {
            throw new OutOfCardsException();
        }
        if (this.selectedListData.getCard() == null) {
            throw new CancelledException();
        }
        return this.selectedListData.getCard();
    }

    private void initComponents(String title) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                this.dialog = new JDialog((Frame)null, title, true);
                this.masterPanel = new JPanel(new BorderLayout());
                this.masterPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
                this.listModel = new DefaultListModel();
                this.list = new JList<ListData>(this.listModel);
                this.list.setCellRenderer(new EidListCellRenderer());
                this.masterPanel.add(this.list);
                this.dialog.add(this.masterPanel);
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void updateListData(ListData listData) {
        SwingUtilities.invokeLater(() -> {
            int index = this.listModel.indexOf(listData);
            if (index != -1) {
                this.listModel.set(index, listData);
            }
        });
    }

    private void addToList(ListData listData) {
        SwingUtilities.invokeLater(() -> this.listModel.addElement(listData));
    }

    private void removeFromList(ListData listData) {
        SwingUtilities.invokeLater(() -> {
            this.listModel.removeElement(listData);
            if (this.listModel.isEmpty()) {
                this.selectedListData.card = null;
                this.outOfCards = true;
                this.dialog.dispose();
            } else {
                this.dialog.pack();
            }
        });
    }

    private void repack() {
        SwingUtilities.invokeLater(() -> this.dialog.pack());
    }

    private class ListMouseAdapter
    extends MouseAdapter {
        private ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int index;
            JList theList = (JList)mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2 && (index = theList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                BeIDSelector.this.stop();
                Object object = theList.getModel().getElementAt(index);
                ListData listData = (ListData)object;
                BeIDSelector.this.selectedListData.card = listData.getCard();
                BeIDSelector.this.dialog.dispose();
            }
        }
    }

    private static class ListDataUpdater
    implements Runnable {
        private final BeIDSelector selectionDialog;
        private final ListData listData;
        private final Thread worker;

        public ListDataUpdater(BeIDSelector selectionDialog, ListData listData) {
            this.selectionDialog = selectionDialog;
            this.listData = listData;
            this.worker = new Thread((Runnable)this, "ListDataUpdater");
            this.worker.setDaemon(true);
            this.setWorkerName(null, null);
            this.selectionDialog.startReadingIdentity();
        }

        public void stop() {
            this.worker.interrupt();
        }

        public void start() {
            this.worker.start();
        }

        public void join() throws InterruptedException {
            this.worker.join();
        }

        @Override
        public void run() {
            Identity identity = null;
            this.setWorkerName(null, "Reading Identity");
            try {
                identity = (Identity)TlvParser.parse((byte[])this.listData.getCard().readFile(FileType.Identity), Identity.class);
                this.listData.setIdentity(identity);
                this.selectionDialog.updateListData(this.listData);
                this.setWorkerName(identity, "Identity Read");
            }
            catch (Exception ex) {
                this.listData.setError();
                this.selectionDialog.updateListData(this.listData);
                this.setWorkerName(identity, "Error Reading Identity");
            }
            finally {
                this.selectionDialog.endReadingIdentity();
            }
            this.setWorkerName(identity, "Reading Photo");
            try {
                this.listData.setPhotoSizeEstimate(FileType.Photo.getEstimatedMaxSize());
                this.selectionDialog.updateListData(this.listData);
                this.listData.getCard().addCardListener(new BeIDCardListener(){

                    public void notifyReadProgress(FileType fileType, int offset, int estimatedMaxSize) {
                        listData.setPhotoProgress(offset);
                        selectionDialog.updateListData(listData);
                    }

                    public void notifySigningBegin(FileType keyType) {
                    }

                    public void notifySigningEnd(FileType keyType) {
                    }
                });
                byte[] photoFile = this.listData.getCard().readFile(FileType.Photo);
                BufferedImage photoImage = ImageIO.read(new ByteArrayInputStream(photoFile));
                this.listData.setPhoto(new ImageIcon(photoImage));
                this.selectionDialog.updateListData(this.listData);
                this.setWorkerName(identity, "All Done");
            }
            catch (Exception ex) {
                this.listData.setError();
                this.selectionDialog.updateListData(this.listData);
                this.setWorkerName(identity, "Error Reading Photo");
            }
        }

        private void setWorkerName(Identity identity, String activity) {
            StringBuilder builder = new StringBuilder("ListDataUpdater");
            if (identity != null) {
                builder.append(" [");
                if (identity.getFirstName() != null) {
                    builder.append(identity.getFirstName());
                    builder.append(" ");
                }
                if (identity.getName() != null) {
                    builder.append(identity.getName());
                }
                builder.append("]");
            }
            if (activity != null) {
                builder.append(" [");
                builder.append(activity);
                builder.append("]");
            }
            this.worker.setName(builder.toString());
        }

        public ListData getListData() {
            return this.listData;
        }
    }

    private static class IdentityPanel
    extends JPanel {
        public IdentityPanel(Identity identity) {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.setMinimumSize(new Dimension(140, 200));
            this.setOpaque(false);
            if (identity == null) {
                this.add(new JLabel("-"));
            } else {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.anchor = 21;
                gbc.ipady = 4;
                this.add((Component)new JLabel(identity.getName()), gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 1;
                gbc.anchor = 21;
                gbc.ipady = 4;
                this.add((Component)new JLabel(identity.getFirstName() + " " + identity.getMiddleName()), gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.ipady = 8;
                this.add(Box.createVerticalGlue(), gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 3;
                gbc.anchor = 21;
                gbc.ipady = 4;
                DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.getDefault());
                this.add((Component)new JLabel(identity.getPlaceOfBirth() + " " + dateFormat.format(identity.getDateOfBirth().getTime())), gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 4;
                gbc.ipady = 8;
                this.add(Box.createVerticalGlue(), gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 5;
                gbc.anchor = 21;
                gbc.ipady = 4;
                this.add((Component)new JLabel(identity.getNationality().toUpperCase()), gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 6;
                gbc.ipady = 8;
                this.add(Box.createVerticalGlue(), gbc);
                gbc = new GridBagConstraints();
                gbc.gridy = 7;
                gbc.anchor = 21;
                gbc.ipady = 4;
                this.add((Component)new JLabel(Format.formatCardNumber((String)identity.getCardNumber())), gbc);
            }
        }
    }

    private static class PhotoPanel
    extends JPanel {
        private JProgressBar progressBar;

        public PhotoPanel(ImageIcon photo, int progress, int max) {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            Dimension fixedSize = new Dimension(140, 200);
            this.setPreferredSize(fixedSize);
            this.setMinimumSize(fixedSize);
            this.setMaximumSize(fixedSize);
            if (photo == null) {
                this.progressBar = new JProgressBar(0, max);
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(progress);
                fixedSize = new Dimension(100, 16);
                this.progressBar.setPreferredSize(fixedSize);
                this.add(this.progressBar);
            } else {
                this.add(new JLabel(photo));
            }
        }
    }

    private static class EidListCellRenderer
    extends JPanel
    implements ListCellRenderer<ListData> {
        private EidListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ListData> list, ListData listData, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(0));
            if (listData.hasError()) {
                panel.setBackground(this.redden(isSelected ? list.getSelectionBackground() : list.getBackground()));
            } else {
                panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            }
            panel.add(new PhotoPanel(listData.getPhoto(), listData.getPhotoProgress(), listData.getPhotoSizeEstimate()));
            panel.add(new IdentityPanel(listData.getIdentity()));
            return panel;
        }

        private Color redden(Color originalColor) {
            Color less = originalColor.darker().darker();
            Color more = originalColor.brighter().brighter();
            return new Color(more.getRed(), less.getGreen(), less.getBlue());
        }
    }

    private static class ListData {
        private BeIDCard card;
        private Identity identity;
        private ImageIcon photo;
        private int photoProgress;
        private int photoSizeEstimate;
        private boolean error;

        public ListData(BeIDCard card) {
            this.card = card;
        }

        public BeIDCard getCard() {
            return this.card;
        }

        public ImageIcon getPhoto() {
            return this.photo;
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public void setIdentity(Identity identity) {
            this.identity = identity;
        }

        public void setPhoto(ImageIcon photo) {
            this.photo = photo;
        }

        public int getPhotoProgress() {
            return this.photoProgress;
        }

        public void setPhotoProgress(int photoProgress) {
            this.photoProgress = photoProgress;
        }

        public void setPhotoSizeEstimate(int photoSizeEstimate) {
            this.photoSizeEstimate = photoSizeEstimate;
        }

        public int getPhotoSizeEstimate() {
            return this.photoSizeEstimate;
        }

        public boolean hasError() {
            return this.error;
        }

        public void setError() {
            this.error = true;
        }
    }
}

