/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.consumer.tlv;

import be.bosa.commons.eid.consumer.tlv.ByteArrayField;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ByteArrayParser {
    private ByteArrayParser() {
    }

    public static <T> T parse(byte[] file, Class<T> baClass) {
        T t;
        try {
            t = ByteArrayParser.parseThrowing(file, baClass);
        }
        catch (Exception ex) {
            throw new RuntimeException("error parsing file: " + baClass.getName(), ex);
        }
        return t;
    }

    private static <T> T parseThrowing(byte[] data, Class<T> baClass) throws InstantiationException, IllegalAccessException {
        Field[] fields = baClass.getDeclaredFields();
        T baObject = baClass.newInstance();
        block4: for (Field field : fields) {
            ByteArrayField baFieldAnnotation = field.getAnnotation(ByteArrayField.class);
            if (baFieldAnnotation == null) continue;
            int offset = baFieldAnnotation.offset();
            int length = baFieldAnnotation.length();
            if (field.getType().isArray() && field.getType().getComponentType().equals(Byte.TYPE)) {
                byte[] byteArray = new byte[length];
                System.arraycopy(data, offset, byteArray, 0, length);
                field.set(baObject, byteArray);
                continue;
            }
            if (!field.getType().equals(Integer.TYPE)) continue;
            ByteBuffer buff = ByteBuffer.wrap(data);
            switch (length) {
                case 1: {
                    field.set(baObject, buff.get(offset) & 0xFF);
                    continue block4;
                }
                case 2: {
                    field.set(baObject, buff.getShort(offset) & 0xFFFF);
                }
            }
        }
        return baObject;
    }
}

