/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.consumer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public enum SpecialOrganisation implements Serializable
{
    UNSPECIFIED(null),
    SHAPE("1"),
    NATO("2"),
    FORMER_BLUE_CARD_HOLDER("4"),
    RESEARCHER("5"),
    UNKNOWN(null);

    private final String key;
    private static final Map<String, SpecialOrganisation> specialOrganisations;

    private SpecialOrganisation(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    private static Map<String, SpecialOrganisation> getSpecialOrganisations() {
        HashMap<String, SpecialOrganisation> specialOrganisations = new HashMap<String, SpecialOrganisation>();
        for (SpecialOrganisation specialOrganisation : SpecialOrganisation.values()) {
            String key = specialOrganisation.getKey();
            if (key == null) continue;
            if (specialOrganisations.containsKey(key)) {
                throw new RuntimeException("duplicate key for special organisation type: " + key);
            }
            specialOrganisations.put(key, specialOrganisation);
        }
        return specialOrganisations;
    }

    public static SpecialOrganisation toSpecialOrganisation(String key) {
        if (null == key || key.isEmpty()) {
            return UNSPECIFIED;
        }
        SpecialOrganisation specialOrganisation = specialOrganisations.get(key);
        if (null == specialOrganisation) {
            return UNKNOWN;
        }
        return specialOrganisation;
    }

    static {
        specialOrganisations = SpecialOrganisation.getSpecialOrganisations();
    }
}

