/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.consumer;

import be.bosa.commons.eid.consumer.Address;
import be.bosa.commons.eid.consumer.Identity;
import be.bosa.commons.eid.consumer.tlv.TlvParser;
import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDIntegrity {
    private static final Log LOG = LogFactory.getLog(BeIDIntegrity.class);
    private final CertificateFactory certificateFactory;

    public BeIDIntegrity() {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException cex) {
            throw new RuntimeException("X.509 algo", cex);
        }
    }

    public X509Certificate loadCertificate(byte[] encodedCertificate) {
        X509Certificate certificate;
        try {
            certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(encodedCertificate));
        }
        catch (CertificateException cex) {
            throw new RuntimeException("X509 decoding error: " + cex.getMessage(), cex);
        }
        return certificate;
    }

    public Identity getVerifiedIdentity(byte[] identityFile, byte[] identitySignatureFile, X509Certificate rrnCertificate) throws NoSuchAlgorithmException {
        return this.getVerifiedIdentity(identityFile, identitySignatureFile, null, rrnCertificate);
    }

    public Identity getVerifiedIdentity(byte[] identityFile, byte[] identitySignatureFile, byte[] photo, X509Certificate rrnCertificate) throws NoSuchAlgorithmException {
        byte[] actualPhotoDigest;
        byte[] expectedPhotoDigest;
        PublicKey publicKey = rrnCertificate.getPublicKey();
        try {
            boolean result = this.verifySignature(rrnCertificate.getSigAlgName(), identitySignatureFile, publicKey, (byte[][])new byte[][]{identityFile});
            if (!result) {
                throw new SecurityException("signature integrity error");
            }
        }
        catch (Exception ex) {
            throw new SecurityException("identity signature verification error: " + ex.getMessage(), ex);
        }
        Identity identity = TlvParser.parse(identityFile, Identity.class);
        if (null != photo && !Arrays.equals(expectedPhotoDigest = identity.getPhotoDigest(), actualPhotoDigest = this.digest(this.getDigestAlgo(expectedPhotoDigest.length), photo))) {
            throw new SecurityException("photo digest mismatch");
        }
        return identity;
    }

    public Address getVerifiedAddress(byte[] addressFile, byte[] identitySignatureFile, byte[] addressSignatureFile, X509Certificate rrnCertificate) {
        byte[] trimmedAddressFile = this.trimRight(addressFile);
        PublicKey publicKey = rrnCertificate.getPublicKey();
        try {
            if (!this.verifySignature(rrnCertificate.getSigAlgName(), addressSignatureFile, publicKey, (byte[][])new byte[][]{trimmedAddressFile, identitySignatureFile})) {
                throw new SecurityException("address integrity error");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new SecurityException("address signature verification error: " + ex.getMessage(), ex);
        }
        return TlvParser.parse(addressFile, Address.class);
    }

    public boolean verifySignature(byte[] signatureData, PublicKey publicKey, byte[] ... data) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return this.verifySignature("SHA256withRSA", signatureData, publicKey, data);
    }

    public boolean verifySignature(String signatureAlgo, byte[] signatureData, PublicKey publicKey, byte[] ... data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signatureAlgo);
        signature.initVerify(publicKey);
        for (byte[] dataItem : data) {
            signature.update(dataItem);
        }
        return signature.verify(signatureData);
    }

    private byte[] digest(String algoName, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algoName);
        return messageDigest.digest(data);
    }

    private byte[] trimRight(byte[] addressFile) {
        int idx;
        for (idx = 0; idx < addressFile.length && 0 != addressFile[idx]; ++idx) {
        }
        byte[] result = new byte[idx];
        System.arraycopy(addressFile, 0, result, 0, idx);
        return result;
    }

    public boolean verifyAuthnSignature(byte[] toBeSigned, byte[] signatureValue, X509Certificate authnCertificate) {
        try {
            PublicKey publicKey = authnCertificate.getPublicKey();
            return this.verifySignature(signatureValue, publicKey, new byte[][]{toBeSigned});
        }
        catch (InvalidKeyException ikex) {
            LOG.warn((Object)("invalid key: " + ikex.getMessage()), (Throwable)ikex);
            return false;
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOG.warn((Object)("no such algo: " + nsaex.getMessage()), (Throwable)nsaex);
            return false;
        }
        catch (SignatureException sigex) {
            LOG.warn((Object)("signature error: " + sigex.getMessage()), (Throwable)sigex);
            return false;
        }
    }

    private String getDigestAlgo(int hashSize) throws NoSuchAlgorithmException {
        switch (hashSize) {
            case 20: {
                return "SHA-1";
            }
            case 28: {
                return "SHA-224";
            }
            case 32: {
                return "SHA-256";
            }
            case 48: {
                return "SHA-384";
            }
            case 64: {
                return "SHA-512";
            }
        }
        throw new NoSuchAlgorithmException("Failed to find guess algorithm for hash size of " + hashSize + " bytes");
    }
}

