/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.client.impl;

import be.bosa.commons.eid.client.impl.VoidLogger;
import be.bosa.commons.eid.client.spi.Logger;
import java.io.File;

public class LibJ2PCSCGNULinuxFix {
    private static final int PCSC_LIBRARY_VERSION = 1;
    private static final String SMARTCARDIO_LIBRARY_PROPERTY = "sun.security.smartcardio.library";
    private static final String LIBRARY_PATH_PROPERTY = "java.library.path";
    private static final String GNULINUX_OS_PROPERTY_PREFIX = "Linux";
    private static final String PCSC_LIBRARY_NAME = "pcsclite";
    private static final String UBUNTU_MULTILIB_32_SUFFIX = "i386-linux-gnu";
    private static final String UBUNTU_MULTILIB_64_SUFFIX = "x86_64-linux-gnu";
    private static final String JRE_BITNESS_PROPERTY = "os.arch";
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final String JRE_BITNESS_32_VALUE = "i386";
    private static final String JRE_BITNESS_64_VALUE = "amd64";

    private LibJ2PCSCGNULinuxFix() {
    }

    public static void fixNativeLibrary() {
        LibJ2PCSCGNULinuxFix.fixNativeLibrary(new VoidLogger());
    }

    public static void fixNativeLibrary(Logger logger) {
        String osName = System.getProperty(OS_NAME_PROPERTY);
        if (osName != null && osName.startsWith(GNULINUX_OS_PROPERTY_PREFIX)) {
            logger.debug("OS is [" + osName + "]. Enabling PCSC library fix.");
            File libPcscLite = LibJ2PCSCGNULinuxFix.findGNULinuxNativeLibrary(PCSC_LIBRARY_NAME, 1, logger);
            if (libPcscLite != null) {
                logger.debug("Setting [sun.security.smartcardio.library] to [" + libPcscLite.getAbsolutePath() + "]");
                System.setProperty(SMARTCARDIO_LIBRARY_PROPERTY, libPcscLite.getAbsolutePath());
            }
        } else {
            logger.debug("OS is [" + osName + "]. Not Enabling PCSC library fix.");
        }
    }

    private static UbuntuBitness getUbuntuBitness() {
        boolean has64;
        File multiLibDir32 = new File("/lib/i386-linux-gnu");
        boolean has32 = multiLibDir32.exists() && multiLibDir32.isDirectory();
        File multiLibDir64 = new File("/lib/x86_64-linux-gnu");
        boolean bl = has64 = multiLibDir64.exists() && multiLibDir64.isDirectory();
        if (has32) {
            if (!has64) {
                return UbuntuBitness.PURE32;
            }
            return UbuntuBitness.MULTILIB;
        }
        if (has64) {
            return UbuntuBitness.PURE64;
        }
        return UbuntuBitness.NA;
    }

    private static String extendLibraryPath(String libPath, String extension) {
        return libPath.contains(extension) ? libPath : libPath + ":" + extension;
    }

    private static String addMultiarchPath(String libPath, String suffix) {
        String retval = LibJ2PCSCGNULinuxFix.extendLibraryPath(libPath, "/lib/" + suffix);
        return LibJ2PCSCGNULinuxFix.extendLibraryPath(retval, "/usr/lib/" + suffix);
    }

    private static String fixPathForUbuntuMultiLib(String libraryPath, Logger logger) {
        logger.debug("Looking for Debian/Ubuntu-style multilib installation.");
        switch (LibJ2PCSCGNULinuxFix.getUbuntuBitness()) {
            case PURE32: {
                logger.debug("pure 32-bit Debian/Ubuntu detected, adding library paths containing 32-bit multilib suffix: i386-linux-gnu");
                return LibJ2PCSCGNULinuxFix.addMultiarchPath(libraryPath, UBUNTU_MULTILIB_32_SUFFIX);
            }
            case PURE64: {
                logger.debug("pure 64-bit Debian/Ubuntu detected, adding library paths containing 64-bit multilib suffix: x86_64-linux-gnu");
                return LibJ2PCSCGNULinuxFix.addMultiarchPath(libraryPath, UBUNTU_MULTILIB_64_SUFFIX);
            }
            case MULTILIB: {
                logger.debug("Multilib Ubuntu detected. Using JRE Bitness.");
                String jvmBinaryArch = System.getProperty(JRE_BITNESS_PROPERTY);
                if (jvmBinaryArch == null) {
                    return libraryPath;
                }
                logger.debug("JRE Bitness is [" + jvmBinaryArch + "]");
                if (jvmBinaryArch.equals(JRE_BITNESS_32_VALUE)) {
                    logger.debug("32-bit JRE, using 32-bit multilib suffix: i386-linux-gnu");
                    return LibJ2PCSCGNULinuxFix.addMultiarchPath(libraryPath, UBUNTU_MULTILIB_32_SUFFIX);
                }
                if (!jvmBinaryArch.equals(JRE_BITNESS_64_VALUE)) break;
                logger.debug("64-bit JRE, using 64-bit multilib suffix: x86_64-linux-gnu");
                return LibJ2PCSCGNULinuxFix.addMultiarchPath(libraryPath, UBUNTU_MULTILIB_64_SUFFIX);
            }
        }
        logger.debug("Did not find Debian/Ubuntu-style multilib.");
        return libraryPath;
    }

    private static File findGNULinuxNativeLibrary(String baseName, int version, Logger logger) {
        String nativeLibraryPaths = System.getProperty(LIBRARY_PATH_PROPERTY);
        if (nativeLibraryPaths == null) {
            return null;
        }
        logger.debug("Original Path=[" + nativeLibraryPaths + "]");
        nativeLibraryPaths = LibJ2PCSCGNULinuxFix.fixPathForUbuntuMultiLib(nativeLibraryPaths, logger);
        logger.debug("Path after Ubuntu multilib Fixes=[" + nativeLibraryPaths + "]");
        String libFileName = System.mapLibraryName(baseName) + "." + version;
        logger.debug("Scanning path for [" + libFileName + "]");
        for (String nativeLibraryPath : nativeLibraryPaths.split(":")) {
            logger.debug("Scanning [" + nativeLibraryPath + "]");
            File libraryFile = new File(nativeLibraryPath, libFileName);
            if (!libraryFile.exists()) continue;
            logger.debug("[" + libFileName + "] found in [" + nativeLibraryPath + "]");
            return libraryFile;
        }
        logger.debug("[" + libFileName + "] not found.");
        return null;
    }

    static enum UbuntuBitness {
        NA,
        PURE32,
        PURE64,
        MULTILIB;

    }
}

