/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.client.impl;

import be.bosa.commons.eid.client.exception.BeIDException;
import be.bosa.commons.eid.client.spi.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Locale;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class CCID {
    private static final int GET_FEATURES = 1107299656;
    private static final int GET_FEATURES_ON_WINDOWS = 3224864;
    private static final int MIN_PIN_SIZE = 4;
    private static final int MAX_PIN_SIZE = 12;
    private static final String DUTCH_LANGUAGE = "nl";
    private static final String FRENCH_LANGUAGE = Locale.FRENCH.getLanguage();
    private static final String GERMAN_LANGUAGE = Locale.GERMAN.getLanguage();
    private static final int DUTCH_LANGUAGE_CODE = 19;
    private static final int FRENCH_LANGUAGE_CODE = 12;
    private static final int GERMAN_LANGUAGE_CODE = 7;
    private static final int ENGLISH_LANGUAGE_CODE = 9;
    private final Logger logger;
    private final Card card;
    private final EnumMap<FEATURE, Integer> features;
    private boolean usesPPDU;
    private static boolean riskPpdu;
    private static final Collection<String> PPDU_NAMES;

    public CCID(Card card, CardTerminal cardTerminal, Logger logger) {
        this.card = card;
        this.logger = logger;
        this.features = new EnumMap(FEATURE.class);
        this.usesPPDU = false;
        boolean onMSWindows = System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows");
        try {
            this.getFeaturesUsingControlChannel(card, onMSWindows);
        }
        catch (CardException cexInNormal) {
            this.logger.debug("GET_FEATURES over standard control command failed: " + cexInNormal.getMessage());
        }
        if (this.features.isEmpty()) {
            if (onMSWindows && this.isPPDUCardTerminal(cardTerminal.getName())) {
                this.logger.debug("Attempting To get CCID FEATURES using Pseudo-APDU Fallback Strategy");
                try {
                    this.getFeaturesUsingPPDU(card);
                }
                catch (CardException cexInPseudo) {
                    this.logger.error("Pseudo-APDU Fallback strategy failed as well: " + cexInPseudo.getMessage());
                }
            } else {
                this.logger.debug("Not risking PPDU Fallback strategy for CardTerminal [" + cardTerminal.getName() + "] on this platform");
            }
        }
    }

    private void getFeaturesUsingControlChannel(Card card, boolean onMSWindows) throws CardException {
        this.logger.debug("Getting CCID FEATURES using standard control command");
        byte[] featureBytes = card.transmitControlCommand(onMSWindows ? 3224864 : 1107299656, new byte[0]);
        this.logger.debug("CCID FEATURES found using standard control command");
        for (FEATURE feature : FEATURE.values()) {
            Integer featureCode = this.findFeatureTLV(feature.getTag(), featureBytes);
            if (featureCode == null) continue;
            this.features.put(feature, featureCode);
            this.logger.debug("FEATURE " + feature.name() + " = " + Integer.toHexString(featureCode));
        }
    }

    private Integer findFeatureTLV(byte featureTag, byte[] features) {
        for (int idx = 0; idx < features.length; idx += 4) {
            byte tag = features[idx];
            idx += 2;
            if (featureTag != tag) continue;
            int feature = 0;
            for (int count = 0; count < 3; ++count) {
                feature |= features[idx] & 0xFF;
                ++idx;
                feature <<= 8;
            }
            return feature |= features[idx] & 0xFF;
        }
        return null;
    }

    private void getFeaturesUsingPPDU(Card card) throws CardException {
        ResponseAPDU responseAPDU = card.getBasicChannel().transmit(new CommandAPDU(-1, -62, 1, 0, new byte[0], 32));
        this.logger.debug("PPDU response: " + Integer.toHexString(responseAPDU.getSW()));
        if (responseAPDU.getSW() == 36864) {
            byte[] featureBytes = responseAPDU.getData();
            this.logger.debug("CCID FEATURES found using Pseudo-APDU Fallback Strategy");
            for (FEATURE feature : FEATURE.values()) {
                Integer featureCode = this.findFeaturePPDU(feature.getTag(), featureBytes);
                this.features.put(feature, featureCode);
                if (featureCode == null) continue;
                this.logger.debug("FEATURE " + feature.name() + " = " + Integer.toHexString(featureCode));
            }
            this.usesPPDU = true;
        } else {
            this.logger.error("CCID Features via PPDU Not Supported");
        }
    }

    private Integer findFeaturePPDU(byte featureTag, byte[] features) {
        for (byte tag : features) {
            if (featureTag != tag) continue;
            return tag;
        }
        return null;
    }

    public boolean usesPPDU() {
        return this.usesPPDU;
    }

    public boolean hasFeature(FEATURE feature) {
        return this.getFeature(feature) != null;
    }

    public Integer getFeature(FEATURE feature) {
        return this.features.get((Object)feature);
    }

    protected byte[] transmitPPDUCommand(int controlCode, byte[] command) throws CardException, BeIDException {
        ResponseAPDU responseAPDU = this.card.getBasicChannel().transmit(new CommandAPDU(-1, -62, 1, controlCode, command));
        if (responseAPDU.getSW() != 36864) {
            throw new BeIDException("PPDU Command Failed: ResponseAPDU=" + responseAPDU.getSW());
        }
        return responseAPDU.getData().length == 0 ? responseAPDU.getBytes() : responseAPDU.getData();
    }

    protected byte[] transmitControlCommand(int controlCode, byte[] command) throws BeIDException {
        try {
            if (this.usesPPDU()) {
                return this.transmitPPDUCommand(controlCode, command);
            }
            return this.card.transmitControlCommand(controlCode, command);
        }
        catch (CardException e) {
            throw new BeIDException("Error transmitting control command", e);
        }
    }

    public void waitForOK() throws BeIDException, InterruptedException {
        block8: while (true) {
            byte[] keyPressedResult = this.transmitControlCommand(this.getFeature(FEATURE.GET_KEY_PRESSED), new byte[0]);
            byte key = keyPressedResult[0];
            switch (key) {
                case 0: {
                    this.logger.debug("waiting for CCID...");
                    Thread.sleep(200L);
                    continue block8;
                }
                case 43: {
                    this.logger.debug("PIN digit");
                    continue block8;
                }
                case 10: {
                    this.logger.debug("erase PIN digit");
                    continue block8;
                }
                case 13: {
                    this.logger.debug("user confirmed");
                    return;
                }
                case 27: {
                    this.logger.debug("user canceled");
                    throw new SecurityException("canceled by user");
                }
                case 64: {
                    this.logger.debug("PIN abort");
                    return;
                }
            }
            this.logger.debug("CCID get key pressed result: " + key + " hex: " + Integer.toHexString(key));
        }
    }

    public byte getLanguageId(Locale locale) {
        String language = locale.getLanguage();
        if (DUTCH_LANGUAGE.equals(language)) {
            return 19;
        }
        if (FRENCH_LANGUAGE.equals(language)) {
            return 12;
        }
        if (GERMAN_LANGUAGE.equals(language)) {
            return 7;
        }
        return 9;
    }

    public byte[] createPINVerificationDataStructure(Locale locale, INS ins) throws IOException {
        ByteArrayOutputStream verifyCommand = new ByteArrayOutputStream();
        verifyCommand.write(30);
        verifyCommand.write(30);
        verifyCommand.write(137);
        verifyCommand.write(71);
        verifyCommand.write(4);
        verifyCommand.write(new byte[]{12, 4});
        verifyCommand.write(2);
        verifyCommand.write(1);
        verifyCommand.write(new byte[]{this.getLanguageId(locale), 4});
        verifyCommand.write(0);
        verifyCommand.write(new byte[]{0, 0, 0});
        byte[] verifyApdu = new byte[]{0, (byte)ins.getIns(), 0, 1, 8, 32, -1, -1, -1, -1, -1, -1, -1};
        verifyCommand.write(verifyApdu.length & 0xFF);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(0);
        verifyCommand.write(verifyApdu);
        return verifyCommand.toByteArray();
    }

    public byte[] createPINModificationDataStructure(Locale locale, INS ins) throws IOException {
        ByteArrayOutputStream modifyCommand = new ByteArrayOutputStream();
        modifyCommand.write(30);
        modifyCommand.write(30);
        modifyCommand.write(137);
        modifyCommand.write(71);
        modifyCommand.write(4);
        modifyCommand.write(0);
        modifyCommand.write(8);
        modifyCommand.write(new byte[]{12, 4});
        modifyCommand.write(3);
        modifyCommand.write(2);
        modifyCommand.write(3);
        modifyCommand.write(new byte[]{this.getLanguageId(locale), 4});
        modifyCommand.write(0);
        modifyCommand.write(1);
        modifyCommand.write(2);
        modifyCommand.write(new byte[]{0, 0, 0});
        byte[] modifyApdu = new byte[]{0, (byte)ins.getIns(), 0, 1, 16, 32, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1};
        modifyCommand.write(modifyApdu.length & 0xFF);
        modifyCommand.write(0);
        modifyCommand.write(0);
        modifyCommand.write(0);
        modifyCommand.write(modifyApdu);
        return modifyCommand.toByteArray();
    }

    public static void setRiskPPDU(boolean riskPpdu) {
        CCID.riskPpdu = riskPpdu;
    }

    private boolean isPPDUCardTerminal(String name) {
        return riskPpdu || PPDU_NAMES.stream().anyMatch(ppduName -> name.toLowerCase().contains((CharSequence)ppduName));
    }

    static {
        PPDU_NAMES = Arrays.asList("Digipass 870".toLowerCase(), "Digipass 875".toLowerCase(), "Digipass 920".toLowerCase());
    }

    public static enum INS {
        VERIFY_PIN(32),
        MODIFY_PIN(36),
        VERIFY_PUK(44);

        private final int ins;

        private INS(int ins) {
            this.ins = ins;
        }

        int getIns() {
            return this.ins;
        }
    }

    public static enum FEATURE {
        VERIFY_PIN_START(1),
        VERIFY_PIN_FINISH(2),
        VERIFY_PIN_DIRECT(6),
        MODIFY_PIN_START(3),
        MODIFY_PIN_FINISH(4),
        MODIFY_PIN_DIRECT(7),
        GET_KEY_PRESSED(5),
        EID_PIN_PAD_READER(128);

        private final byte tag;

        private FEATURE(int tag) {
            this.tag = (byte)tag;
        }

        public byte getTag() {
            return this.tag;
        }
    }
}

