/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.client.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public enum BeIDDigest {
    PLAIN_TEXT(new byte[]{48, -1, 48, 9, 6, 7, 96, 56, 1, 2, 1, 3, 1, 4, -1}),
    SHA_1(new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20}),
    SHA_224(new byte[]{48, 45, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 4, 5, 0, 4, 28}),
    SHA_256(new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32}),
    SHA_384(new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48}),
    SHA_512(new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64}),
    RIPEMD_128(new byte[]{48, 29, 48, 9, 6, 5, 43, 36, 3, 2, 2, 5, 0, 4, 16}),
    RIPEMD_160(new byte[]{48, 33, 48, 9, 6, 5, 43, 36, 3, 2, 1, 5, 0, 4, 20}),
    RIPEMD_256(new byte[]{48, 45, 48, 9, 6, 5, 43, 36, 3, 2, 3, 5, 0, 4, 32}),
    SHA_1_PSS(new byte[0], 16),
    SHA_256_PSS(new byte[0], 32),
    NONE(new byte[0]);

    private final byte[] prefix;
    private final byte algorithmReference;

    private BeIDDigest(byte[] prefix, int algorithmReference) {
        this.prefix = prefix;
        this.algorithmReference = (byte)algorithmReference;
    }

    private BeIDDigest(byte[] prefix) {
        this(prefix, 1);
    }

    public static BeIDDigest getInstance(String name) {
        name = name.replaceAll("-", "_");
        return BeIDDigest.valueOf(name);
    }

    public byte[] getPrefix(int valueLength) {
        if (this.equals((Object)PLAIN_TEXT)) {
            byte[] digestInfoPrefix = Arrays.copyOf(this.prefix, this.prefix.length);
            digestInfoPrefix[1] = (byte)(valueLength + 13);
            digestInfoPrefix[14] = (byte)valueLength;
            return digestInfoPrefix;
        }
        return this.prefix;
    }

    public byte getAlgorithmReference() {
        return this.algorithmReference;
    }

    public String getStandardName() {
        return this.name().replace('_', '-');
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.getStandardName());
    }
}

