/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.client;

import be.bosa.commons.eid.client.BeIDCard;
import be.bosa.commons.eid.client.CardAndTerminalManager;
import be.bosa.commons.eid.client.event.BeIDCardEventsListener;
import be.bosa.commons.eid.client.event.CardEventsListener;
import be.bosa.commons.eid.client.impl.LocaleManager;
import be.bosa.commons.eid.client.impl.VoidLogger;
import be.bosa.commons.eid.client.spi.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardTerminal;

public class BeIDCardManager {
    private static final byte[] ATR_PATTERN = new byte[]{59, -104, 0, 64, 0, 0, 0, 0, 1, 1, -83, 19, 16};
    private static final byte[] ATR_MASK = new byte[]{-1, -1, 0, -1, 0, 0, 0, 0, -1, -1, -1, -1, -16};
    private final CardAndTerminalManager cardAndTerminalManager;
    private final Map<CardTerminal, BeIDCard> terminalsAndCards;
    private final Set<BeIDCardEventsListener> beIdListeners;
    private final Set<CardEventsListener> otherCardListeners;
    private final Logger logger;
    private boolean terminalManagerIsPrivate;

    public BeIDCardManager() {
        this(new VoidLogger());
    }

    public BeIDCardManager(Logger logger) {
        this(logger, new CardAndTerminalManager(logger));
        this.terminalManagerIsPrivate = true;
        this.cardAndTerminalManager.setProtocol(CardAndTerminalManager.Protocol.T0);
    }

    public BeIDCardManager(CardAndTerminalManager cardAndTerminalManager) {
        this(new VoidLogger(), cardAndTerminalManager);
    }

    public BeIDCardManager(Logger logger, CardAndTerminalManager cardAndTerminalManager) {
        this.logger = logger;
        this.beIdListeners = Collections.synchronizedSet(new HashSet());
        this.otherCardListeners = Collections.synchronizedSet(new HashSet());
        this.terminalsAndCards = Collections.synchronizedMap(new HashMap());
        this.cardAndTerminalManager = cardAndTerminalManager;
        this.cardAndTerminalManager.addCardListener(new DefaultCardEventsListener());
    }

    public BeIDCardManager start() {
        if (this.terminalManagerIsPrivate) {
            this.cardAndTerminalManager.start();
        }
        return this;
    }

    public BeIDCardManager addBeIDCardEventListener(BeIDCardEventsListener listener) {
        this.beIdListeners.add(listener);
        return this;
    }

    public BeIDCardManager removeBeIDCardListener(BeIDCardEventsListener listener) {
        this.beIdListeners.remove(listener);
        return this;
    }

    public BeIDCardManager addOtherCardEventListener(CardEventsListener listener) {
        this.otherCardListeners.add(listener);
        return this;
    }

    public BeIDCardManager removeOtherCardEventListener(CardEventsListener listener) {
        this.otherCardListeners.remove(listener);
        return this;
    }

    public BeIDCardManager stop() throws InterruptedException {
        if (this.terminalManagerIsPrivate) {
            this.cardAndTerminalManager.stop();
        }
        return this;
    }

    private boolean matchesEidAtr(ATR atr) {
        byte[] atrBytes = atr.getBytes();
        if (atrBytes.length != ATR_PATTERN.length) {
            return false;
        }
        for (int idx = 0; idx < atrBytes.length; ++idx) {
            int n = idx;
            atrBytes[n] = (byte)(atrBytes[n] & ATR_MASK[idx]);
        }
        return Arrays.equals(atrBytes, ATR_PATTERN);
    }

    public BeIDCardManager setLocale(Locale newLocale) {
        LocaleManager.setLocale(newLocale);
        return this;
    }

    public Locale getLocale() {
        return LocaleManager.getLocale();
    }

    private class DefaultCardEventsListener
    implements CardEventsListener {
        private DefaultCardEventsListener() {
        }

        @Override
        public void cardInserted(CardTerminal cardTerminal, Card card) {
            if (card != null && BeIDCardManager.this.matchesEidAtr(card.getATR())) {
                BeIDCard beIDCard = new BeIDCard(cardTerminal, card, BeIDCardManager.this.logger);
                beIDCard.setLocale(LocaleManager.getLocale());
                BeIDCardManager.this.terminalsAndCards.put(cardTerminal, beIDCard);
                for (BeIDCardEventsListener listener : this.copyOf(BeIDCardManager.this.beIdListeners)) {
                    try {
                        listener.eIDCardInserted(cardTerminal, beIDCard);
                    }
                    catch (Throwable thrownInListener) {
                        BeIDCardManager.this.logger.error("Exception thrown in BeIDCardEventsListener.eIDCardInserted:" + thrownInListener.getMessage());
                    }
                }
            } else {
                for (CardEventsListener listener : this.copyOf(BeIDCardManager.this.otherCardListeners)) {
                    try {
                        listener.cardInserted(cardTerminal, card);
                    }
                    catch (Throwable thrownInListener) {
                        BeIDCardManager.this.logger.error("Exception thrown in CardEventsListener.cardInserted:" + thrownInListener.getMessage());
                    }
                }
            }
        }

        @Override
        public void cardRemoved(CardTerminal cardTerminal) {
            BeIDCard beIDCard = (BeIDCard)BeIDCardManager.this.terminalsAndCards.get(cardTerminal);
            if (beIDCard != null) {
                beIDCard.close();
                BeIDCardManager.this.terminalsAndCards.remove(cardTerminal);
                for (BeIDCardEventsListener listener : this.copyOf(BeIDCardManager.this.beIdListeners)) {
                    try {
                        listener.eIDCardRemoved(cardTerminal, beIDCard);
                    }
                    catch (Throwable thrownInListener) {
                        BeIDCardManager.this.logger.error("Exception thrown in BeIDCardEventsListener.eIDCardRemoved:" + thrownInListener.getMessage());
                    }
                }
            } else {
                for (CardEventsListener listener : this.copyOf(BeIDCardManager.this.otherCardListeners)) {
                    try {
                        listener.cardRemoved(cardTerminal);
                    }
                    catch (Throwable thrownInListener) {
                        BeIDCardManager.this.logger.error("Exception thrown in CardEventsListener.cardRemoved:" + thrownInListener.getMessage());
                    }
                }
            }
        }

        @Override
        public void cardEventsInitialized() {
            for (Object listener : this.copyOf(BeIDCardManager.this.beIdListeners)) {
                try {
                    listener.eIDCardEventsInitialized();
                }
                catch (Throwable thrownInListener) {
                    BeIDCardManager.this.logger.error("Exception thrown in BeIDCardEventsListener.eIDCardInserted:" + thrownInListener.getMessage());
                }
            }
            for (Object listener : this.copyOf(BeIDCardManager.this.otherCardListeners)) {
                try {
                    listener.cardEventsInitialized();
                }
                catch (Throwable thrownInListener) {
                    BeIDCardManager.this.logger.error("Exception thrown in BeIDCardEventsListener.eIDCardInserted:" + thrownInListener.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> Set<T> copyOf(Set<T> set) {
            Set<T> set2 = set;
            synchronized (set2) {
                return new HashSet<T>(set);
            }
        }
    }
}

