/*
 * Decompiled with CFR 0.152.
 */
package be.bosa.commons.eid.client;

import be.bosa.commons.eid.client.CancelledException;
import be.bosa.commons.eid.client.FileType;
import be.bosa.commons.eid.client.PINPurpose;
import be.bosa.commons.eid.client.event.BeIDCardListener;
import be.bosa.commons.eid.client.exception.BeIDException;
import be.bosa.commons.eid.client.exception.ResponseAPDUException;
import be.bosa.commons.eid.client.impl.BeIDDigest;
import be.bosa.commons.eid.client.impl.CCID;
import be.bosa.commons.eid.client.impl.LocaleManager;
import be.bosa.commons.eid.client.impl.VoidLogger;
import be.bosa.commons.eid.client.spi.BeIDCardUI;
import be.bosa.commons.eid.client.spi.Logger;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class BeIDCard
implements AutoCloseable {
    private static final String UI_MISSING_LOG_MESSAGE = "No BeIDCardUI set and can't load DefaultBeIDCardUI";
    private static final String UI_DEFAULT_REQUIRES_HEAD = "No BeIDCardUI set and DefaultBeIDCardUI requires a graphical environment";
    private static final String DEFAULT_UI_IMPLEMENTATION = "be.bosa.commons.eid.dialogs.DefaultBeIDCardUI";
    private static final byte[] BELPIC_AID = new byte[]{-96, 0, 0, 1, 119, 80, 75, 67, 83, 45, 49, 53};
    private static final byte[] APPLET_AID = new byte[]{-96, 0, 0, 0, 48, 41, 5, 112, 0, -83, 19, 16, 1, 1, -1};
    private static final int BLOCK_SIZE = 255;
    private final CardChannel cardChannel;
    private final List<BeIDCardListener> cardListeners;
    private final CertificateFactory certificateFactory;
    private final Card card;
    private final CardTerminal cardTerminal;
    private final Logger logger;
    private CCID ccid;
    private BeIDCardUI ui;
    private Locale locale;
    private Thread exclusiveAccessThread;

    public BeIDCard(CardTerminal cardTerminal, Card card, Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger expected");
        }
        this.cardTerminal = cardTerminal;
        this.card = card;
        this.logger = logger;
        this.cardChannel = card.getBasicChannel();
        this.cardListeners = new LinkedList<BeIDCardListener>();
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("X.509 algo", e);
        }
    }

    public BeIDCard(CardTerminal cardTerminal, Card card) {
        this(cardTerminal, card, new VoidLogger());
    }

    public BeIDCard(CardTerminal cardTerminal, Logger logger) throws BeIDException {
        this(cardTerminal, BeIDCard.connect(cardTerminal), logger);
    }

    private static Card connect(CardTerminal cardTerminal) throws BeIDException {
        try {
            return cardTerminal.connect("T=0");
        }
        catch (CardException e) {
            throw new BeIDException(e);
        }
    }

    @Override
    public void close() {
        this.logger.debug("closing eID card");
        try {
            this.card.disconnect(true);
        }
        catch (CardException e) {
            this.logger.error("could not disconnect the card: " + e.getMessage());
        }
    }

    public void setUI(BeIDCardUI userInterface) {
        this.ui = userInterface;
        if (this.locale == null) {
            this.setLocale(userInterface.getLocale());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCardListener(BeIDCardListener beIDCardListener) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            this.cardListeners.add(beIDCardListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCardListener(BeIDCardListener beIDCardListener) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            this.cardListeners.remove(beIDCardListener);
        }
    }

    public X509Certificate getCertificate(FileType fileType) throws BeIDException, InterruptedException {
        return this.generateCertificateOfType(fileType);
    }

    public X509Certificate getAuthenticationCertificate() throws BeIDException, InterruptedException {
        return this.getCertificate(FileType.AuthentificationCertificate);
    }

    public X509Certificate getSigningCertificate() throws BeIDException, InterruptedException {
        return this.getCertificate(FileType.NonRepudiationCertificate);
    }

    public X509Certificate getCACertificate() throws BeIDException, InterruptedException {
        return this.getCertificate(FileType.CACertificate);
    }

    public X509Certificate getRootCACertificate() throws BeIDException, InterruptedException {
        return this.getCertificate(FileType.RootCertificate);
    }

    public X509Certificate getRRNCertificate() throws BeIDException, InterruptedException {
        return this.getCertificate(FileType.RRNCertificate);
    }

    public List<X509Certificate> getCertificateChain(FileType fileType) throws BeIDException, InterruptedException {
        LinkedList<X509Certificate> chain = new LinkedList<X509Certificate>();
        chain.add(this.generateCertificateOfType(fileType));
        if (fileType.chainIncludesCitizenCA()) {
            chain.add(this.generateCertificateOfType(FileType.CACertificate));
        }
        chain.add(this.generateCertificateOfType(FileType.RootCertificate));
        return chain;
    }

    public List<X509Certificate> getAuthenticationCertificateChain() throws BeIDException, InterruptedException {
        return this.getCertificateChain(FileType.AuthentificationCertificate);
    }

    public List<X509Certificate> getSigningCertificateChain() throws BeIDException, InterruptedException {
        return this.getCertificateChain(FileType.NonRepudiationCertificate);
    }

    public List<X509Certificate> getCACertificateChain() throws BeIDException, InterruptedException {
        return this.getCertificateChain(FileType.CACertificate);
    }

    public List<X509Certificate> getRRNCertificateChain() throws BeIDException, InterruptedException {
        return this.getCertificateChain(FileType.RRNCertificate);
    }

    public byte[] signAuthn(byte[] toBeSigned, boolean requireSecureReader) throws GeneralSecurityException, BeIDException, InterruptedException, CancelledException {
        MessageDigest messageDigest = BeIDDigest.SHA_256.getMessageDigestInstance();
        byte[] digest = messageDigest.digest(toBeSigned);
        return this.sign(digest, BeIDDigest.SHA_256, FileType.AuthentificationCertificate, requireSecureReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] digestValue, BeIDDigest digestAlgo, FileType fileType, boolean requireSecureReader) throws BeIDException, InterruptedException, CancelledException {
        if (!fileType.isCertificateUserCanSignWith()) {
            throw new IllegalArgumentException("Not a certificate that can be used for signing: " + fileType.name());
        }
        if (this.getCCID().hasFeature(CCID.FEATURE.EID_PIN_PAD_READER)) {
            this.logger.debug("eID-aware secure PIN pad reader detected");
        }
        if (requireSecureReader && !this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT) && this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_START)) {
            throw new SecurityException("not a secure reader");
        }
        try {
            this.beginExclusive();
            this.notifySigningBegin(fileType);
            try {
                this.logger.debug("selecting key...");
                ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_ALGORITHM_AND_PRIVATE_KEY, new byte[]{4, -128, digestAlgo.getAlgorithmReference(), -124, fileType.getKeyId()});
                if (36864 != responseApdu.getSW()) {
                    throw new ResponseAPDUException("SET (select algorithm and private key) error", responseApdu);
                }
                if (FileType.NonRepudiationCertificate.getKeyId() == fileType.getKeyId()) {
                    this.logger.debug("non-repudiation key detected, immediate PIN verify");
                    this.verifyPin(PINPurpose.NonRepudiationSignature);
                }
                ByteArrayOutputStream digestInfo = new ByteArrayOutputStream();
                digestInfo.write(digestAlgo.getPrefix(digestValue.length));
                digestInfo.write(digestValue);
                this.logger.debug("computing digital signature...");
                responseApdu = this.transmitCommand(BeIDCommandAPDU.COMPUTE_DIGITAL_SIGNATURE, digestInfo.toByteArray());
                if (36864 == responseApdu.getSW()) {
                    byte[] byArray = responseApdu.getData();
                    return byArray;
                }
                if (27010 != responseApdu.getSW()) {
                    this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
                    throw new ResponseAPDUException("compute digital signature error", responseApdu);
                }
                this.logger.debug("PIN verification required...");
                this.verifyPin(PINPurpose.fromFileType(fileType));
                this.logger.debug("computing digital signature (attempt #2 after PIN verification)...");
                responseApdu = this.transmitCommand(BeIDCommandAPDU.COMPUTE_DIGITAL_SIGNATURE, digestInfo.toByteArray());
                if (36864 != responseApdu.getSW()) {
                    throw new ResponseAPDUException("compute digital signature error", responseApdu);
                }
                byte[] byArray = responseApdu.getData();
                return byArray;
            }
            finally {
                this.endExclusive();
                this.notifySigningEnd(fileType);
            }
        }
        catch (IOException e) {
            throw new BeIDException("Cannot sign", e);
        }
    }

    public void verifyPin() throws BeIDException, InterruptedException, CancelledException {
        this.verifyPin(PINPurpose.PINTest);
    }

    public void changePin(boolean requireSecureReader) throws BeIDException, InterruptedException {
        ResponseAPDU responseApdu;
        if (requireSecureReader && !this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_DIRECT) && !this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_START)) {
            throw new SecurityException("not a secure reader");
        }
        int retriesLeft = -1;
        do {
            if (this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_START)) {
                this.logger.debug("using modify pin start/finish...");
                responseApdu = this.changePINViaCCIDStartFinish(retriesLeft);
            } else if (this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_DIRECT)) {
                this.logger.debug("could use direct PIN modify here...");
                responseApdu = this.changePINViaCCIDDirect(retriesLeft);
            } else {
                responseApdu = this.changePINViaUI(retriesLeft);
            }
            if (36864 == responseApdu.getSW()) continue;
            this.logger.debug("CHANGE PIN error");
            this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.getUI().advisePINBlocked();
                throw new ResponseAPDUException("eID card blocked!", responseApdu);
            }
            if (99 != responseApdu.getSW1()) {
                this.logger.debug("PIN change error. Card blocked?");
                throw new ResponseAPDUException("PIN Change Error", responseApdu);
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.logger.debug("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
        this.getUI().advisePINChanged();
    }

    public byte[] getChallenge(int size) throws BeIDException, InterruptedException {
        ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.GET_CHALLENGE, new byte[0], 0, 0, size);
        if (36864 != responseApdu.getSW()) {
            this.logger.debug("get challenge failure: " + Integer.toHexString(responseApdu.getSW()));
            throw new ResponseAPDUException("get challenge failure: " + Integer.toHexString(responseApdu.getSW()), responseApdu);
        }
        if (size != responseApdu.getData().length) {
            throw new IllegalArgumentException("challenge size incorrect: " + responseApdu.getData().length);
        }
        return responseApdu.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] signTransactionMessage(String transactionMessage, boolean requireSecureReader) throws BeIDException, InterruptedException, CancelledException {
        byte[] signature;
        if (this.getCCID().hasFeature(CCID.FEATURE.EID_PIN_PAD_READER)) {
            this.getUI().adviseSecureReaderOperation();
        }
        try {
            signature = this.sign(transactionMessage.getBytes(), BeIDDigest.PLAIN_TEXT, FileType.AuthentificationCertificate, requireSecureReader);
        }
        finally {
            if (this.getCCID().hasFeature(CCID.FEATURE.EID_PIN_PAD_READER)) {
                this.getUI().adviseSecureReaderOperationEnd();
            }
        }
        return signature;
    }

    public void logoff() throws BeIDException, InterruptedException {
        CommandAPDU logoffApdu = new CommandAPDU(128, 230, 0, 0);
        this.logger.debug("logoff...");
        ResponseAPDU responseApdu = this.transmit(logoffApdu);
        if (36864 != responseApdu.getSW()) {
            throw new RuntimeException("logoff failed");
        }
    }

    public void unblockPin(boolean requireSecureReader) throws BeIDException, InterruptedException {
        ResponseAPDU responseApdu;
        if (requireSecureReader && !this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT)) {
            throw new SecurityException("Not a secure reader");
        }
        int retriesLeft = -1;
        do {
            if (this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT)) {
                this.logger.debug("could use direct PIN verify here...");
                responseApdu = this.unblockPINViaCCIDVerifyPINDirectOfPUK(retriesLeft);
            } else {
                responseApdu = this.unblockPINViaUI(retriesLeft);
            }
            if (36864 == responseApdu.getSW()) continue;
            this.logger.debug("PIN unblock error");
            this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.getUI().advisePINBlocked();
                throw new ResponseAPDUException("eID card blocked!", responseApdu);
            }
            if (99 != responseApdu.getSW1()) {
                this.logger.debug("PIN unblock error.");
                throw new ResponseAPDUException("PIN unblock error", responseApdu);
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.logger.debug("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
        this.getUI().advisePINUnblocked();
    }

    public ATR getATR() {
        return this.card.getATR();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return LocaleManager.getLocale();
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        if (this.locale != null && this.ui != null) {
            this.ui.setLocale(this.locale);
        }
    }

    public void selectApplet() throws InterruptedException, BeIDException {
        ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_APPLET, BELPIC_AID);
        if (36864 != responseApdu.getSW()) {
            this.logger.error("error selecting BELPIC applet");
            this.logger.debug("status word: " + Integer.toHexString(responseApdu.getSW()));
        } else {
            this.logger.debug("BELPIC JavaCard applet selected by BELPIC_AID");
        }
    }

    public void beginExclusive() throws BeIDException {
        if (this.exclusiveAccessThread != null) {
            throw new IllegalStateException("Exclusive access already granted to " + this.exclusiveAccessThread.getName());
        }
        this.logger.debug("---begin exclusive---");
        try {
            this.card.beginExclusive();
            this.exclusiveAccessThread = Thread.currentThread();
        }
        catch (CardException e) {
            throw new BeIDException("Cannot begin exclusive", e);
        }
    }

    public boolean hasExclusive() {
        return this.exclusiveAccessThread == Thread.currentThread();
    }

    public void endExclusive() throws BeIDException {
        if (Thread.currentThread() != this.exclusiveAccessThread) {
            return;
        }
        this.logger.debug("---end exclusive---");
        try {
            this.exclusiveAccessThread = null;
            this.card.endExclusive();
        }
        catch (CardException e) {
            throw new BeIDException("Cannot begin exclusive", e);
        }
    }

    public byte[] readBinary(FileType fileType, int estimatedMaxSize) throws BeIDException, InterruptedException {
        byte[] data;
        int offset = 0;
        this.logger.debug("read binary");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            if (Thread.currentThread().isInterrupted()) {
                this.logger.debug("interrupted in readBinary");
                throw new InterruptedException();
            }
            this.notifyReadProgress(fileType, offset, estimatedMaxSize);
            ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.READ_BINARY, offset >> 8, offset & 0xFF, 255);
            int sw = responseApdu.getSW();
            if (27392 == sw) break;
            if (36864 != sw) {
                throw new BeIDException("BeIDCommandAPDU response error: " + responseApdu.getSW(), new ResponseAPDUException(responseApdu));
            }
            data = responseApdu.getData();
            try {
                baos.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            offset += data.length;
        } while (255 == data.length);
        this.notifyReadProgress(fileType, offset, offset);
        return baos.toByteArray();
    }

    public void selectFile(byte[] fileId) throws BeIDException, InterruptedException {
        this.logger.debug("selecting file");
        ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_FILE, fileId);
        if (36864 != responseApdu.getSW()) {
            throw new BeIDException("Wrong status word after selecting file: " + Integer.toHexString(responseApdu.getSW()));
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("sleep error: " + e.getMessage());
        }
    }

    private X509Certificate generateCertificateOfType(FileType fileType) throws BeIDException, InterruptedException {
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(this.readFile(fileType));
        try {
            return (X509Certificate)this.certificateFactory.generateCertificate(certificateInputStream);
        }
        catch (CertificateException e) {
            throw new BeIDException("Invalid certificate", e);
        }
    }

    public byte[] readFile(FileType fileType) throws BeIDException, InterruptedException {
        this.beginExclusive();
        try {
            this.selectFile(fileType.getFileId());
            byte[] byArray = this.readBinary(fileType, fileType.getEstimatedMaxSize());
            return byArray;
        }
        finally {
            this.endExclusive();
        }
    }

    public boolean cardTerminalHasCCIDFeature(CCID.FEATURE feature) {
        return this.getCCID().hasFeature(feature);
    }

    public void removeCard() throws InterruptedException, BeIDException {
        try {
            while (this.cardTerminal.isCardPresent()) {
                Thread.sleep(100L);
            }
        }
        catch (CardException e) {
            throw new BeIDException("Error waiting for card removal", e);
        }
    }

    private byte[] transmitCCIDControl(boolean usePPDU, CCID.FEATURE feature) throws BeIDException {
        return this.transmitControlCommand(this.getCCID().getFeature(feature), new byte[0]);
    }

    private byte[] transmitCCIDControl(boolean usePPDU, CCID.FEATURE feature, byte[] command) throws BeIDException, InterruptedException {
        return usePPDU ? this.transmitPPDUCommand(feature.getTag(), command) : this.transmitControlCommand(this.getCCID().getFeature(feature), command);
    }

    private byte[] transmitControlCommand(int controlCode, byte[] command) throws BeIDException {
        try {
            return this.card.transmitControlCommand(controlCode, command);
        }
        catch (CardException e) {
            throw new BeIDException("Cannot transmit control command", e);
        }
    }

    private byte[] transmitPPDUCommand(int controlCode, byte[] command) throws BeIDException, InterruptedException {
        ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.PPDU, controlCode, command);
        if (responseAPDU.getSW() != 36864) {
            throw new BeIDException("PPDU Command Failed: ResponseAPDU=" + responseAPDU.getSW());
        }
        if (responseAPDU.getNr() == 0) {
            return responseAPDU.getBytes();
        }
        return responseAPDU.getData();
    }

    private ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, int le) throws BeIDException, InterruptedException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), apdu.getP2(), le));
    }

    private ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, int p2, byte[] data) throws BeIDException, InterruptedException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), p2, data));
    }

    private ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, int p1, int p2, int le) throws BeIDException, InterruptedException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), p1, p2, le));
    }

    private ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, byte[] data) throws BeIDException, InterruptedException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), apdu.getP2(), data));
    }

    private ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, byte[] data, int dataOffset, int dataLength, int ne) throws BeIDException, InterruptedException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), apdu.getP2(), data, dataOffset, dataLength, ne));
    }

    private ResponseAPDU transmit(CommandAPDU commandApdu) throws BeIDException, InterruptedException {
        try {
            ResponseAPDU responseApdu = this.cardChannel.transmit(commandApdu);
            if (108 == responseApdu.getSW1()) {
                this.logger.debug("sleeping...");
                Thread.sleep(10L);
                responseApdu = this.cardChannel.transmit(commandApdu);
            }
            return responseApdu;
        }
        catch (CardException e) {
            throw new BeIDException("Cannot transmit data", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReadProgress(FileType fileType, int offset, int estimatedMaxOffset) {
        if (offset > estimatedMaxOffset) {
            estimatedMaxOffset = offset;
        }
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            for (BeIDCardListener listener : this.cardListeners) {
                try {
                    listener.notifyReadProgress(fileType, offset, estimatedMaxOffset);
                }
                catch (Exception ex) {
                    this.logger.debug("Exception Thrown In BeIDCardListener.notifyReadProgress():" + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySigningBegin(FileType keyType) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            for (BeIDCardListener listener : this.cardListeners) {
                try {
                    listener.notifySigningBegin(keyType);
                }
                catch (Exception ex) {
                    this.logger.debug("Exception Thrown In BeIDCardListener.notifySigningBegin():" + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySigningEnd(FileType keyType) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            for (BeIDCardListener listener : this.cardListeners) {
                try {
                    listener.notifySigningEnd(keyType);
                }
                catch (Exception ex) {
                    this.logger.debug("Exception Thrown In BeIDCardListener.notifySigningBegin():" + ex.getMessage());
                }
            }
        }
    }

    private void verifyPin(PINPurpose purpose) throws BeIDException, InterruptedException, CancelledException {
        ResponseAPDU responseApdu;
        int retriesLeft = -1;
        do {
            if (36864 == (responseApdu = this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT) ? this.verifyPINViaCCIDDirect(retriesLeft, purpose) : (this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_START) ? this.verifyPINViaCCIDStartFinish(retriesLeft, purpose) : this.verifyPINViaUI(retriesLeft, purpose))).getSW()) continue;
            this.logger.debug("VERIFY_PIN error");
            this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.getUI().advisePINBlocked();
                throw new ResponseAPDUException("eID card blocked!", responseApdu);
            }
            if (99 != responseApdu.getSW1()) {
                this.logger.debug("PIN verification error.");
                throw new ResponseAPDUException("PIN Verification Error", responseApdu);
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.logger.debug("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
    }

    private ResponseAPDU verifyPINViaCCIDDirect(int retriesLeft, PINPurpose purpose) throws BeIDException, InterruptedException {
        byte[] result;
        this.logger.debug("direct PIN verification...");
        this.getUI().advisePINPadPINEntry(retriesLeft, purpose);
        try {
            result = this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_DIRECT, this.getCCID().createPINVerificationDataStructure(this.getLocale(), CCID.INS.VERIFY_PIN));
        }
        catch (IOException e) {
            throw new BeIDException(e);
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        ResponseAPDU responseApdu = new ResponseAPDU(result);
        if (25601 == responseApdu.getSW()) {
            this.logger.debug("canceled by user");
            throw new SecurityException("canceled by user", new ResponseAPDUException(responseApdu));
        }
        if (25600 == responseApdu.getSW()) {
            this.logger.debug("PIN pad timeout");
        }
        return responseApdu;
    }

    private ResponseAPDU verifyPINViaCCIDStartFinish(int retriesLeft, PINPurpose purpose) throws BeIDException, InterruptedException {
        this.logger.debug("CCID verify PIN start/end sequence...");
        this.getUI().advisePINPadPINEntry(retriesLeft, purpose);
        try {
            this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_START, this.getCCID().createPINVerificationDataStructure(this.getLocale(), CCID.INS.VERIFY_PIN));
            this.getCCID().waitForOK();
        }
        catch (IOException e) {
            throw new BeIDException("Cannot verify pin", e);
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        return new ResponseAPDU(this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_FINISH));
    }

    private boolean isWindows8Or10() {
        String osName = System.getProperty("os.name");
        return osName.contains("Windows 8") || osName.contains("Windows 10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPINViaUI(int retriesLeft, PINPurpose purpose) throws CancelledException, BeIDException, InterruptedException {
        boolean windows8 = this.isWindows8Or10();
        if (windows8) {
            this.endExclusive();
        }
        char[] pin = this.getUI().obtainPIN(retriesLeft, purpose);
        if (windows8) {
            this.beginExclusive();
        }
        byte[] verifyData = new byte[]{(byte)(0x20 | pin.length), -1, -1, -1, -1, -1, -1, -1};
        for (int idx = 0; idx < pin.length; idx += 2) {
            byte value;
            char digit1 = pin[idx];
            int digit2 = idx + 1 < pin.length ? pin[idx + 1] : 63;
            verifyData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(pin, '\u0000');
        this.logger.debug("verifying PIN...");
        try {
            ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.VERIFY_PIN, verifyData);
            return responseAPDU;
        }
        finally {
            Arrays.fill(verifyData, (byte)0);
        }
    }

    private ResponseAPDU changePINViaCCIDDirect(int retriesLeft) throws BeIDException, InterruptedException {
        byte[] result;
        this.logger.debug("direct PIN modification...");
        this.getUI().advisePINPadChangePIN(retriesLeft);
        try {
            result = this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.MODIFY_PIN_DIRECT, this.getCCID().createPINModificationDataStructure(this.getLocale(), CCID.INS.MODIFY_PIN));
        }
        catch (IOException e) {
            throw new BeIDException("Error changing pin", e);
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        ResponseAPDU responseApdu = new ResponseAPDU(result);
        switch (responseApdu.getSW()) {
            case 25602: {
                this.logger.debug("PINs differ");
                break;
            }
            case 25601: {
                this.logger.debug("canceled by user");
                throw new SecurityException("canceled by user", new ResponseAPDUException(responseApdu));
            }
            case 25600: {
                this.logger.debug("PIN pad timeout");
            }
        }
        return responseApdu;
    }

    private ResponseAPDU changePINViaCCIDStartFinish(int retriesLeft) throws InterruptedException, BeIDException {
        try {
            this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.MODIFY_PIN_START, this.getCCID().createPINModificationDataStructure(this.getLocale(), CCID.INS.MODIFY_PIN));
            this.logger.debug("enter old PIN...");
            this.getUI().advisePINPadOldPINEntry(retriesLeft);
            this.getCCID().waitForOK();
            this.getUI().advisePINPadOperationEnd();
            this.logger.debug("enter new PIN...");
            this.getUI().advisePINPadNewPINEntry(retriesLeft);
            this.getCCID().waitForOK();
            this.getUI().advisePINPadOperationEnd();
            this.logger.debug("enter new PIN again...");
            this.getUI().advisePINPadNewPINEntryAgain(retriesLeft);
            this.getCCID().waitForOK();
        }
        catch (IOException e) {
            throw new BeIDException("Error changing pin", e);
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        return new ResponseAPDU(this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.MODIFY_PIN_FINISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU changePINViaUI(int retriesLeft) throws BeIDException, InterruptedException {
        byte value;
        int digit2;
        char digit1;
        int idx;
        char[][] pins = this.getUI().obtainOldAndNewPIN(retriesLeft);
        char[] oldPin = pins[0];
        char[] newPin = pins[1];
        byte[] changePinData = new byte[]{(byte)(0x20 | oldPin.length), -1, -1, -1, -1, -1, -1, -1, (byte)(0x20 | newPin.length), -1, -1, -1, -1, -1, -1, -1};
        for (idx = 0; idx < oldPin.length; idx += 2) {
            digit1 = oldPin[idx];
            digit2 = idx + 1 < oldPin.length ? oldPin[idx + 1] : 63;
            changePinData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(oldPin, '\u0000');
        for (idx = 0; idx < newPin.length; idx += 2) {
            digit1 = newPin[idx];
            digit2 = idx + 1 < newPin.length ? newPin[idx + 1] : 63;
            changePinData[idx / 2 + 1 + 8] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(newPin, '\u0000');
        try {
            ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.CHANGE_PIN, changePinData);
            return responseAPDU;
        }
        finally {
            Arrays.fill(changePinData, (byte)0);
        }
    }

    private ResponseAPDU unblockPINViaCCIDVerifyPINDirectOfPUK(int retriesLeft) throws BeIDException, InterruptedException {
        byte[] result;
        this.logger.debug("direct PUK verification...");
        this.getUI().advisePINPadPUKEntry(retriesLeft);
        try {
            result = this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_DIRECT, this.getCCID().createPINVerificationDataStructure(this.getLocale(), CCID.INS.VERIFY_PUK));
        }
        catch (IOException e) {
            throw new BeIDException(e);
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        ResponseAPDU responseApdu = new ResponseAPDU(result);
        if (25601 == responseApdu.getSW()) {
            this.logger.debug("canceled by user");
            throw new SecurityException("canceled by user", new ResponseAPDUException(responseApdu));
        }
        if (25600 == responseApdu.getSW()) {
            this.logger.debug("PIN pad timeout");
        }
        return responseApdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU unblockPINViaUI(int retriesLeft) throws BeIDException, InterruptedException {
        char[][] puks = this.getUI().obtainPUKCodes(retriesLeft);
        char[] puk1 = puks[0];
        char[] puk2 = puks[1];
        char[] fullPuk = new char[puk1.length + puk2.length];
        System.arraycopy(puk2, 0, fullPuk, 0, puk2.length);
        Arrays.fill(puk2, '\u0000');
        System.arraycopy(puk1, 0, fullPuk, puk2.length, puk1.length);
        Arrays.fill(puk1, '\u0000');
        byte[] unblockPinData = new byte[]{(byte)(0x20 | (byte)(puk1.length + puk2.length)), -1, -1, -1, -1, -1, -1, -1};
        for (int idx = 0; idx < fullPuk.length; idx += 2) {
            byte value;
            char digit1 = fullPuk[idx];
            char digit2 = fullPuk[idx + 1];
            unblockPinData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(fullPuk, '\u0000');
        try {
            ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.RESET_PIN, unblockPinData);
            return responseAPDU;
        }
        finally {
            Arrays.fill(unblockPinData, (byte)0);
        }
    }

    private CCID getCCID() {
        if (this.ccid == null) {
            this.ccid = new CCID(this.card, this.cardTerminal, this.logger);
        }
        return this.ccid;
    }

    private BeIDCardUI getUI() {
        if (this.ui == null) {
            if (GraphicsEnvironment.isHeadless()) {
                this.logger.error(UI_DEFAULT_REQUIRES_HEAD);
                throw new UnsupportedOperationException(UI_DEFAULT_REQUIRES_HEAD);
            }
            try {
                ClassLoader classLoader = BeIDCard.class.getClassLoader();
                Class<?> uiClass = classLoader.loadClass(DEFAULT_UI_IMPLEMENTATION);
                this.ui = (BeIDCardUI)uiClass.newInstance();
                if (this.locale != null) {
                    this.ui.setLocale(this.locale);
                }
            }
            catch (Exception e) {
                this.logger.error(UI_MISSING_LOG_MESSAGE);
                throw new UnsupportedOperationException(UI_MISSING_LOG_MESSAGE, e);
            }
        }
        return this.ui;
    }

    public CardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    private static enum BeIDCommandAPDU {
        SELECT_APPLET(0, 164, 4, 12),
        SELECT_FILE(0, 164, 8, 12),
        READ_BINARY(0, 176),
        VERIFY_PIN(0, 32, 0, 1),
        CHANGE_PIN(0, 36, 0, 1),
        SELECT_ALGORITHM_AND_PRIVATE_KEY(0, 34, 65, 182),
        COMPUTE_DIGITAL_SIGNATURE(0, 42, 158, 154),
        RESET_PIN(0, 44, 0, 1),
        GET_CHALLENGE(0, 132, 0, 0),
        GET_CARD_DATA(128, 228, 0, 0),
        PPDU(255, 194, 1);

        private final int cla;
        private final int ins;
        private final int p1;
        private final int p2;

        private BeIDCommandAPDU(int cla, int ins, int p1, int p2) {
            this.cla = cla;
            this.ins = ins;
            this.p1 = p1;
            this.p2 = p2;
        }

        private BeIDCommandAPDU(int cla, int ins, int p1) {
            this.cla = cla;
            this.ins = ins;
            this.p1 = p1;
            this.p2 = -1;
        }

        private BeIDCommandAPDU(int cla, int ins) {
            this.cla = cla;
            this.ins = ins;
            this.p1 = -1;
            this.p2 = -1;
        }

        public int getCla() {
            return this.cla;
        }

        public int getIns() {
            return this.ins;
        }

        public int getP1() {
            return this.p1;
        }

        public int getP2() {
            return this.p2;
        }
    }
}

