/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.date.DatePickerController;
import com.fourmob.datetimepicker.date.DatePickerDialog;
import com.fourmob.datetimepicker.date.TextViewWithCircularIndicator;
import java.util.ArrayList;
import java.util.List;

public class YearPickerView
extends ListView
implements AdapterView.OnItemClickListener,
DatePickerDialog.OnDateChangedListener {
    private YearAdapter mAdapter;
    private int mChildSize;
    private final DatePickerController mController;
    private TextViewWithCircularIndicator mSelectedView;
    private int mViewSize;

    public YearPickerView(Context context, DatePickerController datePickerController) {
        super(context);
        this.mController = datePickerController;
        this.mController.registerOnDateChangedListener(this);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        Resources resources = context.getResources();
        this.mViewSize = resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height);
        this.mChildSize = resources.getDimensionPixelOffset(R.dimen.year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.init(context);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.onDateChanged();
    }

    private int getYearFromTextView(TextView textView) {
        return Integer.valueOf(textView.getText().toString());
    }

    private void init(Context context) {
        ArrayList<String> years = new ArrayList<String>();
        for (int year = this.mController.getMinYear(); year <= this.mController.getMaxYear(); ++year) {
            years.add(String.format("%d", year));
        }
        this.mAdapter = new YearAdapter(context, R.layout.year_label_text_view, years);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public int getFirstPositionOffset() {
        View view = this.getChildAt(0);
        if (view == null) {
            return 0;
        }
        return view.getTop();
    }

    @Override
    public void onDateChanged() {
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().year - this.mController.getMinYear());
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mController.tryVibrate();
        TextViewWithCircularIndicator textViewWithCircularIndicator = (TextViewWithCircularIndicator)view;
        if (textViewWithCircularIndicator != null) {
            if (textViewWithCircularIndicator != this.mSelectedView) {
                if (this.mSelectedView != null) {
                    this.mSelectedView.drawIndicator(false);
                    this.mSelectedView.requestLayout();
                }
                textViewWithCircularIndicator.drawIndicator(true);
                textViewWithCircularIndicator.requestLayout();
                this.mSelectedView = textViewWithCircularIndicator;
            }
            this.mController.onYearSelected(this.getYearFromTextView(textViewWithCircularIndicator));
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public void postSetSelectionFromTop(final int position, final int y) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPickerView.this.setSelectionFromTop(position, y);
                YearPickerView.this.requestLayout();
            }
        });
    }

    private class YearAdapter
    extends ArrayAdapter<String> {
        public YearAdapter(Context context, int resourceId, List<String> years) {
            super(context, resourceId, years);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextViewWithCircularIndicator textViewWithCircularIndicator = (TextViewWithCircularIndicator)super.getView(position, convertView, parent);
            textViewWithCircularIndicator.requestLayout();
            int year = YearPickerView.this.getYearFromTextView(textViewWithCircularIndicator);
            textViewWithCircularIndicator.drawIndicator(((YearPickerView)YearPickerView.this).mController.getSelectedDay().year == year);
            return textViewWithCircularIndicator;
        }
    }
}

