/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.view.MotionEvent;
import android.view.View;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.SimpleMonthAdapter;
import java.security.InvalidParameterException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;

public class SimpleMonthView
extends View {
    protected static int DAY_SELECTED_CIRCLE_SIZE;
    protected static int DAY_SEPARATOR_WIDTH;
    protected static int DEFAULT_HEIGHT;
    protected static int MINI_DAY_NUMBER_TEXT_SIZE;
    protected static int MIN_HEIGHT;
    protected static int MONTH_DAY_LABEL_TEXT_SIZE;
    protected static int MONTH_HEADER_SIZE;
    protected static int MONTH_LABEL_TEXT_SIZE;
    protected static float mScale;
    private final Calendar mCalendar;
    private final Calendar mDayLabelCalendar;
    private int mDayOfWeekStart = 0;
    private String mDayOfWeekTypeface;
    protected int mDayTextColor;
    protected int mFirstJulianDay = -1;
    protected int mFirstMonth = -1;
    private final Formatter mFormatter;
    protected boolean mHasToday = false;
    protected int mLastMonth = -1;
    protected int mMonth;
    protected Paint mMonthDayLabelPaint;
    protected Paint mMonthNumPaint;
    protected int mMonthTitleBGColor;
    protected Paint mMonthTitleBGPaint;
    protected int mMonthTitleColor;
    protected Paint mMonthTitlePaint;
    private String mMonthTitleTypeface;
    protected int mNumCells = this.mNumDays;
    protected int mNumDays = 7;
    private int mNumRows = 6;
    private OnDayClickListener mOnDayClickListener;
    protected int mPadding = 0;
    protected int mRowHeight = DEFAULT_HEIGHT;
    protected Paint mSelectedCirclePaint;
    protected int mSelectedDay = -1;
    protected int mSelectedLeft = -1;
    protected int mSelectedRight = -1;
    private final StringBuilder mStringBuilder;
    protected int mToday = -1;
    protected int mTodayNumberColor;
    protected int mWeekStart = 1;
    protected int mWidth;
    protected int mYear;
    private DateFormatSymbols mDateFormatSymbols = new DateFormatSymbols();

    public SimpleMonthView(Context context) {
        super(context);
        Resources resources = context.getResources();
        this.mDayLabelCalendar = Calendar.getInstance();
        this.mCalendar = Calendar.getInstance();
        this.mDayOfWeekTypeface = resources.getString(R.string.day_of_week_label_typeface);
        this.mMonthTitleTypeface = resources.getString(R.string.sans_serif);
        this.mDayTextColor = resources.getColor(R.color.date_picker_text_normal);
        this.mTodayNumberColor = resources.getColor(R.color.blue);
        this.mMonthTitleColor = resources.getColor(R.color.white);
        this.mMonthTitleBGColor = resources.getColor(R.color.circle_background);
        this.mStringBuilder = new StringBuilder(50);
        this.mFormatter = new Formatter(this.mStringBuilder, Locale.getDefault());
        MINI_DAY_NUMBER_TEXT_SIZE = resources.getDimensionPixelSize(R.dimen.day_number_size);
        MONTH_LABEL_TEXT_SIZE = resources.getDimensionPixelSize(R.dimen.month_label_size);
        MONTH_DAY_LABEL_TEXT_SIZE = resources.getDimensionPixelSize(R.dimen.month_day_label_text_size);
        MONTH_HEADER_SIZE = resources.getDimensionPixelOffset(R.dimen.month_list_item_header_height);
        DAY_SELECTED_CIRCLE_SIZE = resources.getDimensionPixelSize(R.dimen.day_number_select_circle_radius);
        this.mRowHeight = (resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height) - MONTH_HEADER_SIZE) / 6;
        this.initView();
    }

    private int calculateNumRows() {
        int dayOffset = this.findDayOffset();
        int nbRows = (dayOffset + this.mNumCells) / this.mNumDays;
        int plusOne = 0;
        if ((dayOffset + this.mNumCells) % this.mNumDays > 0) {
            plusOne = 1;
        }
        return plusOne + nbRows;
    }

    private void drawMonthDayLabels(Canvas canvas) {
        int y = MONTH_HEADER_SIZE - MONTH_DAY_LABEL_TEXT_SIZE / 2;
        int space = (this.mWidth - 2 * this.mPadding) / (2 * this.mNumDays);
        for (int day = 0; day < this.mNumDays; ++day) {
            int dayOfWeek = (day + this.mWeekStart) % this.mNumDays;
            int x = space * (1 + day * 2) + this.mPadding;
            this.mDayLabelCalendar.set(7, dayOfWeek);
            canvas.drawText(this.mDateFormatSymbols.getShortWeekdays()[this.mDayLabelCalendar.get(7)].toUpperCase(Locale.getDefault()), (float)x, (float)y, this.mMonthDayLabelPaint);
        }
    }

    private void drawMonthTitle(Canvas canvas) {
        int x = (this.mWidth + 2 * this.mPadding) / 2;
        int y = (MONTH_HEADER_SIZE - MONTH_DAY_LABEL_TEXT_SIZE) / 2 + MONTH_LABEL_TEXT_SIZE / 3;
        canvas.drawText(this.getMonthAndYearString(), (float)x, (float)y, this.mMonthTitlePaint);
    }

    private int findDayOffset() {
        int off = this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + this.mNumDays : this.mDayOfWeekStart;
        return off - this.mWeekStart;
    }

    private String getMonthAndYearString() {
        this.mStringBuilder.setLength(0);
        long dateInMillis = this.mCalendar.getTimeInMillis();
        return DateUtils.formatDateRange((Context)this.getContext(), (long)dateInMillis, (long)dateInMillis, (int)52).toString();
    }

    private void onDayClick(SimpleMonthAdapter.CalendarDay calendarDay) {
        if (this.mOnDayClickListener != null) {
            this.mOnDayClickListener.onDayClick(this, calendarDay);
        }
    }

    private boolean sameDay(int monthDay, Time time) {
        return this.mYear == time.year && this.mMonth == time.month && monthDay == time.monthDay;
    }

    protected void drawMonthNums(Canvas canvas) {
        int y = (this.mRowHeight + MINI_DAY_NUMBER_TEXT_SIZE) / 2 - DAY_SEPARATOR_WIDTH + MONTH_HEADER_SIZE;
        int paddingDay = (this.mWidth - 2 * this.mPadding) / (2 * this.mNumDays);
        int dayOffset = this.findDayOffset();
        for (int day = 1; day <= this.mNumCells; ++day) {
            int x = paddingDay * (1 + dayOffset * 2) + this.mPadding;
            if (this.mSelectedDay == day) {
                canvas.drawCircle((float)x, (float)(y - MINI_DAY_NUMBER_TEXT_SIZE / 3), (float)DAY_SELECTED_CIRCLE_SIZE, this.mSelectedCirclePaint);
            }
            if (this.mHasToday && this.mToday == day) {
                this.mMonthNumPaint.setColor(this.mTodayNumberColor);
            } else {
                this.mMonthNumPaint.setColor(this.mDayTextColor);
            }
            canvas.drawText(String.format("%d", day), (float)x, (float)y, this.mMonthNumPaint);
            if (++dayOffset != this.mNumDays) continue;
            dayOffset = 0;
            y += this.mRowHeight;
        }
    }

    public SimpleMonthAdapter.CalendarDay getDayFromLocation(float x, float y) {
        int padding = this.mPadding;
        if (x < (float)padding || x > (float)(this.mWidth - this.mPadding)) {
            return null;
        }
        int yDay = (int)(y - (float)MONTH_HEADER_SIZE) / this.mRowHeight;
        int day = 1 + ((int)((x - (float)padding) * (float)this.mNumDays / (float)(this.mWidth - padding - this.mPadding)) - this.findDayOffset()) + yDay * this.mNumDays;
        return new SimpleMonthAdapter.CalendarDay(this.mYear, this.mMonth, day);
    }

    protected void initView() {
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setTextSize((float)MONTH_LABEL_TEXT_SIZE);
        this.mMonthTitlePaint.setTypeface(Typeface.create((String)this.mMonthTitleTypeface, (int)1));
        this.mMonthTitlePaint.setColor(this.mDayTextColor);
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitleBGPaint = new Paint();
        this.mMonthTitleBGPaint.setFakeBoldText(true);
        this.mMonthTitleBGPaint.setAntiAlias(true);
        this.mMonthTitleBGPaint.setColor(this.mMonthTitleBGColor);
        this.mMonthTitleBGPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitleBGPaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint = new Paint();
        this.mSelectedCirclePaint.setFakeBoldText(true);
        this.mSelectedCirclePaint.setAntiAlias(true);
        this.mSelectedCirclePaint.setColor(this.mTodayNumberColor);
        this.mSelectedCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedCirclePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint.setAlpha(60);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setTextSize((float)MONTH_DAY_LABEL_TEXT_SIZE);
        this.mMonthDayLabelPaint.setColor(this.mDayTextColor);
        this.mMonthDayLabelPaint.setTypeface(Typeface.create((String)this.mDayOfWeekTypeface, (int)0));
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mMonthNumPaint = new Paint();
        this.mMonthNumPaint.setAntiAlias(true);
        this.mMonthNumPaint.setTextSize((float)MINI_DAY_NUMBER_TEXT_SIZE);
        this.mMonthNumPaint.setStyle(Paint.Style.FILL);
        this.mMonthNumPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthNumPaint.setFakeBoldText(false);
    }

    protected void onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawMonthDayLabels(canvas);
        this.drawMonthNums(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mRowHeight * this.mNumRows + MONTH_HEADER_SIZE);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        SimpleMonthAdapter.CalendarDay calendarDay;
        if (motionEvent.getAction() == 1 && (calendarDay = this.getDayFromLocation(motionEvent.getX(), motionEvent.getY())) != null) {
            this.onDayClick(calendarDay);
        }
        return true;
    }

    public void reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    public void setMonthParams(HashMap<String, Integer> monthParams) {
        if (!monthParams.containsKey("month") && !monthParams.containsKey("year")) {
            throw new InvalidParameterException("You must specify the month and year for this view");
        }
        this.setTag(monthParams);
        if (monthParams.containsKey("height")) {
            this.mRowHeight = monthParams.get("height");
            if (this.mRowHeight < MIN_HEIGHT) {
                this.mRowHeight = MIN_HEIGHT;
            }
        }
        if (monthParams.containsKey("selected_day")) {
            this.mSelectedDay = monthParams.get("selected_day");
        }
        this.mMonth = monthParams.get("month");
        this.mYear = monthParams.get("year");
        Time time = new Time(Time.getCurrentTimezone());
        time.setToNow();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = monthParams.containsKey("week_start") ? monthParams.get("week_start").intValue() : this.mCalendar.getFirstDayOfWeek();
        this.mNumCells = Utils.getDaysInMonth(this.mMonth, this.mYear);
        for (int day = 0; day < this.mNumCells; ++day) {
            int monthDay = day + 1;
            if (!this.sameDay(monthDay, time)) continue;
            this.mHasToday = true;
            this.mToday = monthDay;
        }
        this.mNumRows = this.calculateNumRows();
    }

    public void setOnDayClickListener(OnDayClickListener onDayClickListener) {
        this.mOnDayClickListener = onDayClickListener;
    }

    static {
        DAY_SEPARATOR_WIDTH = 1;
        DEFAULT_HEIGHT = 32;
        MIN_HEIGHT = 10;
        mScale = 0.0f;
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, SimpleMonthAdapter.CalendarDay var2);
    }
}

