/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.fourmob.datetimepicker.date.DatePickerController;
import com.fourmob.datetimepicker.date.DatePickerDialog;
import com.fourmob.datetimepicker.date.SimpleMonthAdapter;
import com.fourmob.datetimepicker.date.SimpleMonthView;

public class DayPickerView
extends ListView
implements AbsListView.OnScrollListener,
DatePickerDialog.OnDateChangedListener {
    public static int LIST_TOP_OFFSET = -1;
    protected SimpleMonthAdapter mAdapter;
    protected Context mContext;
    private final DatePickerController mController;
    protected int mCurrentMonthDisplayed;
    protected int mCurrentScrollState = 0;
    protected int mDaysPerWeek = 7;
    protected float mFriction = 1.0f;
    protected Handler mHandler = new Handler();
    protected int mNumWeeks = 6;
    private boolean mPerformingScroll;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    protected ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();
    protected SimpleMonthAdapter.CalendarDay mSelectedDay = new SimpleMonthAdapter.CalendarDay();
    protected boolean mShowWeekNumber = false;
    protected SimpleMonthAdapter.CalendarDay mTempDay = new SimpleMonthAdapter.CalendarDay();

    public DayPickerView(Context context, DatePickerController datePickerController) {
        super(context);
        this.mController = datePickerController;
        this.mController.registerOnDateChangedListener(this);
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.init(context);
        this.onDateChanged();
    }

    public int getMostVisiblePosition() {
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int height = this.getHeight();
        int maxGap = 0;
        int mostVisiblePosition = 0;
        int childIndex = 0;
        int bottom = 0;
        View childView = null;
        while ((childView = this.getChildAt(childIndex)) != null) {
            if (bottom < height) {
                bottom = childView.getBottom();
                int gap = Math.min(bottom, height) - Math.max(0, childView.getTop());
                if (gap > maxGap) {
                    mostVisiblePosition = childIndex;
                    maxGap = gap;
                }
            } else {
                return firstVisiblePosition + mostVisiblePosition;
            }
            ++childIndex;
        }
        return firstVisiblePosition + mostVisiblePosition;
    }

    public boolean goTo(SimpleMonthAdapter.CalendarDay calendarDay, boolean scrollToTop, boolean selectDay, boolean displayMonth) {
        if (selectDay) {
            this.mSelectedDay.set(calendarDay);
        }
        this.mTempDay.set(calendarDay);
        int monthIndex = 12 * (calendarDay.year - this.mController.getMinYear()) + calendarDay.month;
        this.postSetSelection(monthIndex);
        return true;
    }

    public void init(Context paramContext) {
        this.mContext = paramContext;
        this.setUpListView();
        this.setUpAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.mPerformingScroll) {
            this.mPerformingScroll = false;
        }
    }

    public void onChange() {
        this.setUpAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        SimpleMonthView simpleMonthView = (SimpleMonthView)absListView.getChildAt(0);
        if (simpleMonthView == null) {
            return;
        }
        this.mPreviousScrollPosition = absListView.getFirstVisiblePosition() * simpleMonthView.getHeight() - simpleMonthView.getBottom();
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    public void onScrollStateChanged(AbsListView absListView, int scroll) {
        this.mScrollStateChangedRunnable.doScrollStateChange(absListView, scroll);
    }

    public void postSetSelection(final int position) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                DayPickerView.this.setSelection(position);
            }
        });
        this.onScrollStateChanged((AbsListView)this, 0);
    }

    protected void setMonthDisplayed(SimpleMonthAdapter.CalendarDay calendarDay) {
        this.mCurrentMonthDisplayed = calendarDay.month;
        this.invalidateViews();
    }

    protected void setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new SimpleMonthAdapter(this.getContext(), this.mController);
        }
        this.mAdapter.setSelectedDay(this.mSelectedDay);
        this.mAdapter.notifyDataSetChanged();
    }

    protected void setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFrictionIfSupported(ViewConfiguration.getScrollFriction() * this.mFriction);
    }

    @TargetApi(value=11)
    void setFrictionIfSupported(float friction) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setFriction(friction);
        }
    }

    protected class ScrollStateRunnable
    implements Runnable {
        private int mNewState;

        protected ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView absListView, int newState) {
            DayPickerView.this.mHandler.removeCallbacks((Runnable)this);
            this.mNewState = newState;
            DayPickerView.this.mHandler.postDelayed((Runnable)this, 40L);
        }

        @Override
        public void run() {
        }
    }
}

