/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.SystemClock;
import android.os.Vibrator;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.text.format.DateUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.DatePickerController;
import com.fourmob.datetimepicker.date.DayPickerView;
import com.fourmob.datetimepicker.date.SimpleMonthAdapter;
import com.fourmob.datetimepicker.date.YearPickerView;
import com.nineoldandroids.animation.ObjectAnimator;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class DatePickerDialog
extends DialogFragment
implements View.OnClickListener,
DatePickerController {
    private static final int MAX_YEAR = 2037;
    private static final int MIN_YEAR = 1902;
    private static final int VIEW_DATE_PICKER_YEAR = 1;
    private static final int VIEW_DATE_PICKER_MONTH_DAY = 0;
    private static SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private ViewAnimator mAnimator;
    private final Calendar mCalendar = Calendar.getInstance();
    private OnDateSetListener mCallBack;
    private int mCurrentView = -1;
    private TextView mDayOfWeekView;
    private String mDayPickerDescription;
    private DayPickerView mDayPickerView;
    private boolean mDelayAnimation = true;
    private Button mDoneButton;
    private long mLastVibrate;
    private HashSet<OnDateChangedListener> mListeners = new HashSet();
    private int mMaxYear = 2037;
    private int mMinYear = 1902;
    private LinearLayout mMonthAndDayView;
    private String mSelectDay;
    private String mSelectYear;
    private TextView mSelectedDayTextView;
    private TextView mSelectedMonthTextView;
    private Vibrator mVibrator;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private String mYearPickerDescription;
    private YearPickerView mYearPickerView;
    private TextView mYearView;
    private DateFormatSymbols dateformartsymbols = new DateFormatSymbols();
    private boolean mVibrate = true;

    private void adjustDayInMonthIfNeeded(int month, int year) {
        int day;
        int currentDay = this.mCalendar.get(5);
        if (currentDay > (day = Utils.getDaysInMonth(month, year))) {
            this.mCalendar.set(5, day);
        }
    }

    public static DatePickerDialog newInstance(OnDateSetListener onDateSetListener, int year, int month, int day) {
        return DatePickerDialog.newInstance(onDateSetListener, year, month, day, true);
    }

    public static DatePickerDialog newInstance(OnDateSetListener onDateSetListener, int year, int month, int day, boolean vibrate) {
        DatePickerDialog datePickerDialog = new DatePickerDialog();
        datePickerDialog.initialize(onDateSetListener, year, month, day, vibrate);
        return datePickerDialog;
    }

    public void setVibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    private void setCurrentView(int currentView) {
        this.setCurrentView(currentView, false);
    }

    private void setCurrentView(int currentView, boolean forceRefresh) {
        long timeInMillis = this.mCalendar.getTimeInMillis();
        switch (currentView) {
            case 0: {
                ObjectAnimator monthDayAnim = Utils.getPulseAnimator((View)this.mMonthAndDayView, 0.9f, 1.05f);
                if (this.mDelayAnimation) {
                    monthDayAnim.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != currentView || forceRefresh) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mYearView.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = currentView;
                }
                monthDayAnim.start();
                String monthDayDesc = DateUtils.formatDateTime((Context)this.getActivity(), (long)timeInMillis, (int)16);
                this.mAnimator.setContentDescription((CharSequence)(this.mDayPickerDescription + ": " + monthDayDesc));
                return;
            }
            case 1: {
                ObjectAnimator yearAnim = Utils.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    yearAnim.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != currentView || forceRefresh) {
                    this.mMonthAndDayView.setSelected(false);
                    this.mYearView.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = currentView;
                }
                yearAnim.start();
                String dayDesc = YEAR_FORMAT.format(timeInMillis);
                this.mAnimator.setContentDescription((CharSequence)(this.mYearPickerDescription + ": " + dayDesc));
            }
        }
    }

    private void updateDisplay() {
        if (this.mDayOfWeekView != null) {
            this.mCalendar.setFirstDayOfWeek(this.mWeekStart);
            this.mDayOfWeekView.setText((CharSequence)this.dateformartsymbols.getWeekdays()[this.mCalendar.get(7)].toUpperCase(Locale.getDefault()));
        }
        this.mSelectedMonthTextView.setText((CharSequence)this.dateformartsymbols.getMonths()[this.mCalendar.get(2)].toUpperCase(Locale.getDefault()));
        this.mSelectedDayTextView.setText((CharSequence)DAY_FORMAT.format(this.mCalendar.getTime()));
        this.mYearView.setText((CharSequence)YEAR_FORMAT.format(this.mCalendar.getTime()));
        long timeInMillis = this.mCalendar.getTimeInMillis();
        String desc = DateUtils.formatDateTime((Context)this.getActivity(), (long)timeInMillis, (int)24);
        this.mMonthAndDayView.setContentDescription((CharSequence)desc);
    }

    private void updatePickers() {
        Iterator<OnDateChangedListener> it = this.mListeners.iterator();
        while (it.hasNext()) {
            it.next().onDateChanged();
        }
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public int getMaxYear() {
        return this.mMaxYear;
    }

    @Override
    public int getMinYear() {
        return this.mMinYear;
    }

    @Override
    public SimpleMonthAdapter.CalendarDay getSelectedDay() {
        return new SimpleMonthAdapter.CalendarDay(this.mCalendar);
    }

    public void initialize(OnDateSetListener onDateSetListener, int year, int month, int day, boolean vibrate) {
        if (year > 2037) {
            throw new IllegalArgumentException("year end must < 2037");
        }
        if (year < 1902) {
            throw new IllegalArgumentException("year end must > 1902");
        }
        this.mCallBack = onDateSetListener;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.mVibrate = vibrate;
    }

    public void onClick(View view) {
        this.tryVibrate();
        if (view.getId() == R.id.date_picker_year) {
            this.setCurrentView(1);
        } else if (view.getId() == R.id.date_picker_month_and_day) {
            this.setCurrentView(0);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mVibrator = (Vibrator)activity.getSystemService("vibrator");
        if (bundle != null) {
            this.mCalendar.set(1, bundle.getInt("year"));
            this.mCalendar.set(2, bundle.getInt("month"));
            this.mCalendar.set(5, bundle.getInt("day"));
            this.mVibrate = bundle.getBoolean("vibrate");
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup parent, Bundle bundle) {
        Log.d((String)"DatePickerDialog", (String)"onCreateView: ");
        this.getDialog().getWindow().requestFeature(1);
        View view = layoutInflater.inflate(R.layout.date_picker_dialog, null);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mMonthAndDayView = (LinearLayout)view.findViewById(R.id.date_picker_month_and_day);
        this.mMonthAndDayView.setOnClickListener((View.OnClickListener)this);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.date_picker_month);
        this.mSelectedDayTextView = (TextView)view.findViewById(R.id.date_picker_day);
        this.mYearView = (TextView)view.findViewById(R.id.date_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int currentView = 0;
        int listPositionOffset = 0;
        if (bundle != null) {
            this.mWeekStart = bundle.getInt("week_start");
            this.mMinYear = bundle.getInt("year_start");
            this.mMaxYear = bundle.getInt("year_end");
            currentView = bundle.getInt("current_view");
            listPosition = bundle.getInt("list_position");
            listPositionOffset = bundle.getInt("list_position_offset");
        }
        FragmentActivity activity = this.getActivity();
        this.mDayPickerView = new DayPickerView((Context)activity, this);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        Resources resources = this.getResources();
        this.mDayPickerDescription = resources.getString(R.string.day_picker_description);
        this.mSelectDay = resources.getString(R.string.select_day);
        this.mYearPickerDescription = resources.getString(R.string.year_picker_description);
        this.mSelectYear = resources.getString(R.string.select_year);
        this.mAnimator = (ViewAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        AlphaAnimation inAlphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        inAlphaAnimation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)inAlphaAnimation);
        AlphaAnimation outAlphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        outAlphaAnimation.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)outAlphaAnimation);
        this.mDoneButton = (Button)view.findViewById(R.id.done);
        this.mDoneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DatePickerDialog.this.tryVibrate();
                if (DatePickerDialog.this.mCallBack != null) {
                    DatePickerDialog.this.mCallBack.onDateSet(DatePickerDialog.this, DatePickerDialog.this.mCalendar.get(1), DatePickerDialog.this.mCalendar.get(2), DatePickerDialog.this.mCalendar.get(5));
                }
                DatePickerDialog.this.dismiss();
            }
        });
        this.updateDisplay();
        this.setCurrentView(currentView, true);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            }
            if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        return view;
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt("year", this.mCalendar.get(1));
        bundle.putInt("month", this.mCalendar.get(2));
        bundle.putInt("day", this.mCalendar.get(5));
        bundle.putInt("week_start", this.mWeekStart);
        bundle.putInt("year_start", this.mMinYear);
        bundle.putInt("year_end", this.mMaxYear);
        bundle.putInt("current_view", this.mCurrentView);
        int mostVisiblePosition = -1;
        if (this.mCurrentView == 0) {
            mostVisiblePosition = this.mDayPickerView.getMostVisiblePosition();
        }
        bundle.putInt("list_position", mostVisiblePosition);
        if (this.mCurrentView == 1) {
            mostVisiblePosition = this.mYearPickerView.getFirstVisiblePosition();
            bundle.putInt("list_position_offset", this.mYearPickerView.getFirstPositionOffset());
        }
        bundle.putBoolean("vibrate", this.mVibrate);
    }

    @Override
    public void onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCalendar.get(2), year);
        this.mCalendar.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay();
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.mListeners.add(onDateChangedListener);
    }

    public void setFirstDayOfWeek(int weekStart) {
        if (weekStart < 1 || weekStart > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = weekStart;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setOnDateSetListener(OnDateSetListener onDateSetListener) {
        this.mCallBack = onDateSetListener;
    }

    public void setYearRange(int minYear, int maxYear) {
        if (maxYear <= minYear) {
            throw new IllegalArgumentException("Year end must be larger than year start");
        }
        if (maxYear > 2037) {
            throw new IllegalArgumentException("max year end must < 2037");
        }
        if (minYear < 1902) {
            throw new IllegalArgumentException("min year end must > 1902");
        }
        this.mMinYear = minYear;
        this.mMaxYear = maxYear;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    @Override
    public void tryVibrate() {
        long timeInMillis;
        if (this.mVibrator != null && this.mVibrate && (timeInMillis = SystemClock.uptimeMillis()) - this.mLastVibrate >= 125L) {
            this.mVibrator.vibrate(5L);
            this.mLastVibrate = timeInMillis;
        }
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePickerDialog var1, int var2, int var3, int var4);
    }

    static interface OnDateChangedListener {
        public void onDateChanged();
    }
}

