/*
 * Decompiled with CFR 0.152.
 */
package be.billington.calendar.recurrencepicker;

import android.accounts.Account;
import android.app.Activity;
import android.app.SearchManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.CalendarContract;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.format.Time;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.Log;
import android.widget.SearchView;
import be.billington.calendar.recurrencepicker.R;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final boolean DEBUG = false;
    private static final String TAG = "CalUtils";
    public static final long UNDO_DELAY = 0L;
    public static final int MODIFY_UNINITIALIZED = 0;
    public static final int MODIFY_SELECTED = 1;
    public static final int MODIFY_ALL_FOLLOWING = 2;
    public static final int MODIFY_ALL = 3;
    public static final int DONE_REVERT = 1;
    public static final int DONE_SAVE = 2;
    public static final int DONE_DELETE = 4;
    public static final int DONE_EXIT = 1;
    public static final String OPEN_EMAIL_MARKER = " <";
    public static final String CLOSE_EMAIL_MARKER = ">";
    public static final String INTENT_KEY_DETAIL_VIEW = "DETAIL_VIEW";
    public static final String INTENT_KEY_VIEW_TYPE = "VIEW";
    public static final String INTENT_VALUE_VIEW_TYPE_DAY = "DAY";
    public static final String INTENT_KEY_HOME = "KEY_HOME";
    public static final int MONDAY_BEFORE_JULIAN_EPOCH = 2440585;
    public static final int DECLINED_EVENT_ALPHA = 102;
    public static final int DECLINED_EVENT_TEXT_ALPHA = 192;
    private static final float SATURATION_ADJUST = 1.3f;
    private static final float INTENSITY_ADJUST = 0.8f;
    static final int DAY_IN_MINUTES = 1440;
    static final int WEEK_IN_MINUTES = 10080;
    static int WORK_DAY_MINUTES = 840;
    static int WORK_DAY_START_MINUTES = 360;
    static int WORK_DAY_END_MINUTES = 1200;
    static int WORK_DAY_END_LENGTH = 1440 - WORK_DAY_END_MINUTES;
    static int CONFLICT_COLOR = -16777216;
    static boolean mMinutesLoaded = false;
    public static final int YEAR_MIN = 1970;
    public static final int YEAR_MAX = 2036;
    static final String SHARED_PREFS_NAME = "com.android.calendar_preferences";
    public static final String KEY_QUICK_RESPONSES = "preferences_quick_responses";
    public static final String KEY_ALERTS_VIBRATE_WHEN = "preferences_alerts_vibrateWhen";
    public static final String APPWIDGET_DATA_TYPE = "vnd.android.data/update";
    static final String MACHINE_GENERATED_ADDRESS = "calendar.google.com";
    private static boolean mAllowWeekForDetailView = false;
    private static long mTardis = 0L;
    private static String sVersion = null;
    private static final Pattern mWildcardPattern = Pattern.compile("^.*$");
    private static final String COORD_DEGREES_LATITUDE = "([-+NnSs](\\s)*)?[1-9]?[0-9](\u00b0)(\\s)*([1-5]?[0-9]')?(\\s)*([1-5]?[0-9](\\.[0-9]+)?\")?((\\s)*[NnSs])?";
    private static final String COORD_DEGREES_LONGITUDE = "([-+EeWw](\\s)*)?(1)?[0-9]?[0-9](\u00b0)(\\s)*([1-5]?[0-9]')?(\\s)*([1-5]?[0-9](\\.[0-9]+)?\")?((\\s)*[EeWw])?";
    private static final String COORD_DEGREES_PATTERN = "([-+NnSs](\\s)*)?[1-9]?[0-9](\u00b0)(\\s)*([1-5]?[0-9]')?(\\s)*([1-5]?[0-9](\\.[0-9]+)?\")?((\\s)*[NnSs])?(\\s)*,(\\s)*([-+EeWw](\\s)*)?(1)?[0-9]?[0-9](\u00b0)(\\s)*([1-5]?[0-9]')?(\\s)*([1-5]?[0-9](\\.[0-9]+)?\")?((\\s)*[EeWw])?";
    private static final String COORD_DECIMAL_LATITUDE = "[+-]?[1-9]?[0-9](\\.[0-9]+)(\u00b0)?";
    private static final String COORD_DECIMAL_LONGITUDE = "[+-]?(1)?[0-9]?[0-9](\\.[0-9]+)(\u00b0)?";
    private static final String COORD_DECIMAL_PATTERN = "[+-]?[1-9]?[0-9](\\.[0-9]+)(\u00b0)?(\\s)*,(\\s)*[+-]?(1)?[0-9]?[0-9](\\.[0-9]+)(\u00b0)?";
    private static final Pattern COORD_PATTERN = Pattern.compile("([-+NnSs](\\s)*)?[1-9]?[0-9](\u00b0)(\\s)*([1-5]?[0-9]')?(\\s)*([1-5]?[0-9](\\.[0-9]+)?\")?((\\s)*[NnSs])?(\\s)*,(\\s)*([-+EeWw](\\s)*)?(1)?[0-9]?[0-9](\u00b0)(\\s)*([1-5]?[0-9]')?(\\s)*([1-5]?[0-9](\\.[0-9]+)?\")?((\\s)*[EeWw])?|[+-]?[1-9]?[0-9](\\.[0-9]+)(\u00b0)?(\\s)*,(\\s)*[+-]?(1)?[0-9]?[0-9](\\.[0-9]+)(\u00b0)?");
    private static final String NANP_ALLOWED_SYMBOLS = "()+-*#.";
    private static final int NANP_MIN_DIGITS = 7;
    private static final int NANP_MAX_DIGITS = 11;
    private static final int TODAY = 1;
    private static final int TOMORROW = 2;
    private static final int NONE = 0;

    public static boolean isJellybeanOrLater() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean isKeyLimePieOrLater() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static String getWidgetUpdateAction(Context context) {
        return context.getPackageName() + ".APPWIDGET_UPDATE";
    }

    public static String getWidgetScheduledUpdateAction(Context context) {
        return context.getPackageName() + ".APPWIDGET_SCHEDULED_UPDATE";
    }

    public static String getSearchAuthority(Context context) {
        return context.getPackageName() + ".CalendarRecentSuggestionsProvider";
    }

    protected static void tardis() {
        mTardis = System.currentTimeMillis();
    }

    protected static long getTardis() {
        return mTardis;
    }

    public static MatrixCursor matrixCursorFromCursor(Cursor cursor) {
        if (cursor == null) {
            return null;
        }
        String[] columnNames = cursor.getColumnNames();
        if (columnNames == null) {
            columnNames = new String[]{};
        }
        MatrixCursor newCursor = new MatrixCursor(columnNames);
        int numColumns = cursor.getColumnCount();
        Object[] data = new String[numColumns];
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            for (int i = 0; i < numColumns; ++i) {
                data[i] = cursor.getString(i);
            }
            newCursor.addRow(data);
        }
        return newCursor;
    }

    public static boolean compareCursors(Cursor c1, Cursor c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        int numColumns = c1.getColumnCount();
        if (numColumns != c2.getColumnCount()) {
            return false;
        }
        if (c1.getCount() != c2.getCount()) {
            return false;
        }
        c1.moveToPosition(-1);
        c2.moveToPosition(-1);
        while (c1.moveToNext() && c2.moveToNext()) {
            for (int i = 0; i < numColumns; ++i) {
                if (TextUtils.equals((CharSequence)c1.getString(i), (CharSequence)c2.getString(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static final long timeFromIntentInMillis(Intent intent) {
        List path;
        Uri data = intent.getData();
        long millis = intent.getLongExtra("beginTime", -1L);
        if (millis == -1L && data != null && data.isHierarchical() && (path = data.getPathSegments()).size() == 2 && ((String)path.get(0)).equals("time")) {
            try {
                millis = Long.valueOf(data.getLastPathSegment());
            }
            catch (NumberFormatException e) {
                Log.i((String)"Calendar", (String)"timeFromIntentInMillis: Data existed but no valid time found. Using current time.");
            }
        }
        if (millis <= 0L) {
            millis = System.currentTimeMillis();
        }
        return millis;
    }

    public static String join(List<?> things, String delim) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object thing : things) {
            if (first) {
                first = false;
            } else {
                builder.append(delim);
            }
            builder.append(thing.toString());
        }
        return builder.toString();
    }

    public static int getWeeksSinceEpochFromJulianDay(int julianDay, int firstDayOfWeek) {
        int diff = 4 - firstDayOfWeek;
        if (diff < 0) {
            diff += 7;
        }
        int refDay = 2440588 - diff;
        return (julianDay - refDay) / 7;
    }

    public static int getJulianMondayFromWeeksSinceEpoch(int week) {
        return 2440585 + week * 7;
    }

    public static int getFirstDayOfWeek(Context context) {
        int startDay = Calendar.getInstance().getFirstDayOfWeek();
        if (startDay == 7) {
            return 6;
        }
        if (startDay == 2) {
            return 1;
        }
        return 0;
    }

    public static int getFirstDayOfWeekAsCalendar(Context context) {
        return Utils.convertDayOfWeekFromTimeToCalendar(Utils.getFirstDayOfWeek(context));
    }

    public static int convertDayOfWeekFromTimeToCalendar(int timeDayOfWeek) {
        switch (timeDayOfWeek) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Argument must be between Time.SUNDAY and Time.SATURDAY");
    }

    public static boolean isSaturday(int column, int firstDayOfWeek) {
        return firstDayOfWeek == 0 && column == 6 || firstDayOfWeek == 1 && column == 5 || firstDayOfWeek == 6 && column == 0;
    }

    public static boolean isSunday(int column, int firstDayOfWeek) {
        return firstDayOfWeek == 0 && column == 0 || firstDayOfWeek == 1 && column == 6 || firstDayOfWeek == 6 && column == 1;
    }

    public static long convertAlldayUtcToLocal(Time recycle, long utcTime, String tz) {
        if (recycle == null) {
            recycle = new Time();
        }
        recycle.timezone = "UTC";
        recycle.set(utcTime);
        recycle.timezone = tz;
        return recycle.normalize(true);
    }

    public static long convertAlldayLocalToUTC(Time recycle, long localTime, String tz) {
        if (recycle == null) {
            recycle = new Time();
        }
        recycle.timezone = tz;
        recycle.set(localTime);
        recycle.timezone = "UTC";
        return recycle.normalize(true);
    }

    public static long getNextMidnight(Time recycle, long theTime, String tz) {
        if (recycle == null) {
            recycle = new Time();
        }
        recycle.timezone = tz;
        recycle.set(theTime);
        ++recycle.monthDay;
        recycle.hour = 0;
        recycle.minute = 0;
        recycle.second = 0;
        return recycle.normalize(true);
    }

    public static void checkForDuplicateNames(Map<String, Boolean> isDuplicateName, Cursor cursor, int nameIndex) {
        isDuplicateName.clear();
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            String displayName = cursor.getString(nameIndex);
            if (displayName == null) continue;
            isDuplicateName.put(displayName, isDuplicateName.containsKey(displayName));
        }
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static void setAllowWeekForDetailView(boolean allowWeekView) {
        mAllowWeekForDetailView = allowWeekView;
    }

    public static boolean getAllowWeekForDetailView() {
        return mAllowWeekForDetailView;
    }

    public static boolean getConfigBool(Context c, int key) {
        return c.getResources().getBoolean(key);
    }

    public static int getDisplayColorFromColor(int color2) {
        if (!Utils.isJellybeanOrLater()) {
            return color2;
        }
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[1] = Math.min(hsv[1] * 1.3f, 1.0f);
        hsv[2] = hsv[2] * 0.8f;
        return Color.HSVToColor((float[])hsv);
    }

    public static int getDeclinedColorFromColor(int color2) {
        int bg = -1;
        int a = 102;
        int r = (color2 & 0xFF0000) * a + (bg & 0xFF0000) * (255 - a) & 0xFF000000;
        int g = (color2 & 0xFF00) * a + (bg & 0xFF00) * (255 - a) & 0xFF0000;
        int b = (color2 & 0xFF) * a + (bg & 0xFF) * (255 - a) & 0xFF00;
        return 0xFF000000 | (r | g | b) >> 8;
    }

    private static void weaveDNAStrands(LinkedList<DNASegment> segments, int firstJulianDay, HashMap<Integer, DNAStrand> strands, int top, int bottom, int[] dayXs) {
        Iterator<DNAStrand> strandIterator = strands.values().iterator();
        while (strandIterator.hasNext()) {
            DNAStrand strand = strandIterator.next();
            if (strand.count < 1 && strand.allDays == null) {
                strandIterator.remove();
                continue;
            }
            strand.points = new float[strand.count * 4];
            strand.position = 0;
        }
        for (DNASegment segment : segments) {
            DNAStrand strand = strands.get(segment.color);
            int dayIndex = segment.day - firstJulianDay;
            int dayStartMinute = segment.startMinute % 1440;
            int dayEndMinute = segment.endMinute % 1440;
            int height = bottom - top;
            int workDayHeight = height * 3 / 4;
            int remainderHeight = (height - workDayHeight) / 2;
            int x = dayXs[dayIndex];
            int y0 = 0;
            int y1 = 0;
            y0 = top + Utils.getPixelOffsetFromMinutes(dayStartMinute, workDayHeight, remainderHeight);
            y1 = top + Utils.getPixelOffsetFromMinutes(dayEndMinute, workDayHeight, remainderHeight);
            strand.points[strand.position++] = x;
            strand.points[strand.position++] = y0;
            strand.points[strand.position++] = x;
            strand.points[strand.position++] = y1;
        }
    }

    private static int getPixelOffsetFromMinutes(int minute, int workDayHeight, int remainderHeight) {
        int y = minute < WORK_DAY_START_MINUTES ? minute * remainderHeight / WORK_DAY_START_MINUTES : (minute < WORK_DAY_END_MINUTES ? remainderHeight + (minute - WORK_DAY_START_MINUTES) * workDayHeight / WORK_DAY_MINUTES : remainderHeight + workDayHeight + (minute - WORK_DAY_END_MINUTES) * remainderHeight / WORK_DAY_END_LENGTH);
        return y;
    }

    private static DNAStrand getOrCreateStrand(HashMap<Integer, DNAStrand> strands, int color2) {
        DNAStrand strand = strands.get(color2);
        if (strand == null) {
            strand = new DNAStrand();
            strand.color = color2;
            strand.count = 0;
            strands.put(strand.color, strand);
        }
        return strand;
    }

    public static void setUpSearchView(SearchView view, Activity act) {
        SearchManager searchManager = (SearchManager)act.getSystemService("search");
        view.setSearchableInfo(searchManager.getSearchableInfo(act.getComponentName()));
        view.setQueryRefinementEnabled(true);
    }

    public static void setMidnightUpdater(Handler h, Runnable r, String timezone) {
        if (h == null || r == null || timezone == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Time time = new Time(timezone);
        time.set(now);
        long runInMillis = (86400 - time.hour * 3600 - time.minute * 60 - time.second + 1) * 1000;
        h.removeCallbacks(r);
        h.postDelayed(r, runInMillis);
    }

    public static void resetMidnightUpdater(Handler h, Runnable r) {
        if (h == null || r == null) {
            return;
        }
        h.removeCallbacks(r);
    }

    public static String getDisplayedTimezone(long startMillis, String localTimezone, String eventTimezone) {
        String tzDisplay = null;
        if (!TextUtils.equals((CharSequence)localTimezone, (CharSequence)eventTimezone)) {
            TimeZone tz = TimeZone.getTimeZone(localTimezone);
            if (tz == null || tz.getID().equals("GMT")) {
                tzDisplay = localTimezone;
            } else {
                Time startTime = new Time(localTimezone);
                startTime.set(startMillis);
                tzDisplay = tz.getDisplayName(startTime.isDst != 0, 0);
            }
        }
        return tzDisplay;
    }

    private static boolean singleDayEvent(long startMillis, long endMillis, long localGmtOffset) {
        int endDay;
        if (startMillis == endMillis) {
            return true;
        }
        int startDay = Time.getJulianDay((long)startMillis, (long)localGmtOffset);
        return startDay == (endDay = Time.getJulianDay((long)(endMillis - 1L), (long)localGmtOffset));
    }

    private static int isTodayOrTomorrow(Resources r, long dayMillis, long currentMillis, long localGmtOffset) {
        int currentDay;
        int startDay = Time.getJulianDay((long)dayMillis, (long)localGmtOffset);
        int days = startDay - (currentDay = Time.getJulianDay((long)currentMillis, (long)localGmtOffset));
        if (days == 1) {
            return 2;
        }
        if (days == 0) {
            return 1;
        }
        return 0;
    }

    public static Intent createEmailAttendeesIntent(Resources resources, String eventTitle, String body, List<String> toEmails, List<String> ccEmails, String ownerAccount) {
        String uri;
        List<String> toList = toEmails;
        List<String> ccList = ccEmails;
        if (toEmails.size() <= 0) {
            if (ccEmails.size() <= 0) {
                throw new IllegalArgumentException("Both toEmails and ccEmails are empty.");
            }
            toList = ccEmails;
            ccList = null;
        }
        String subject = null;
        if (eventTitle != null) {
            subject = resources.getString(R.string.email_subject_prefix) + eventTitle;
        }
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme("mailto");
        if (toList.size() > 1) {
            for (int i = 1; i < toList.size(); ++i) {
                uriBuilder.appendQueryParameter("to", toList.get(i));
            }
        }
        if (subject != null) {
            uriBuilder.appendQueryParameter("subject", subject);
        }
        if (body != null) {
            uriBuilder.appendQueryParameter("body", body);
        }
        if (ccList != null && ccList.size() > 0) {
            for (String email : ccList) {
                uriBuilder.appendQueryParameter("cc", email);
            }
        }
        if ((uri = uriBuilder.toString()).startsWith("mailto:")) {
            StringBuilder builder = new StringBuilder(uri);
            builder.insert(7, Uri.encode((String)toList.get(0)));
            uri = builder.toString();
        }
        Intent emailIntent = new Intent("android.intent.action.SENDTO", Uri.parse((String)uri));
        emailIntent.putExtra("fromAccountString", ownerAccount);
        if (body != null) {
            emailIntent.putExtra("android.intent.extra.TEXT", body);
        }
        return Intent.createChooser((Intent)emailIntent, (CharSequence)resources.getString(R.string.email_picker_label));
    }

    public static boolean isValidEmail(String email) {
        return email != null && !email.endsWith(MACHINE_GENERATED_ADDRESS);
    }

    public static boolean isEmailableFrom(String email, String syncAccountName) {
        return Utils.isValidEmail(email) && !email.equals(syncAccountName);
    }

    public static BroadcastReceiver setTimeChangesReceiver(Context c, Runnable callback) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.DATE_CHANGED");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        filter.addAction("android.intent.action.LOCALE_CHANGED");
        CalendarBroadcastReceiver r = new CalendarBroadcastReceiver(callback);
        c.registerReceiver((BroadcastReceiver)r, filter);
        return r;
    }

    public static void clearTimeChangesReceiver(Context c, BroadcastReceiver r) {
        c.unregisterReceiver(r);
    }

    public static String getVersionCode(Context context) {
        if (sVersion == null) {
            try {
                sVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)("Error finding package " + context.getApplicationInfo().packageName));
            }
        }
        return sVersion;
    }

    public static void startCalendarMetafeedSync(Account account) {
        Bundle extras = new Bundle();
        extras.putBoolean("force", true);
        extras.putBoolean("metafeedonly", true);
        ContentResolver.requestSync((Account)account, (String)CalendarContract.Calendars.CONTENT_URI.getAuthority(), (Bundle)extras);
    }

    public static Spannable extendedLinkify(String text, boolean lastDitchGeo) {
        SpannableString spanText = SpannableString.valueOf((CharSequence)text);
        String defaultPhoneRegion = System.getProperty("user.region", "US");
        if (!defaultPhoneRegion.equals("US")) {
            Linkify.addLinks((Spannable)spanText, (int)15);
            URLSpan[] spans = (URLSpan[])spanText.getSpans(0, spanText.length(), URLSpan.class);
            if (spans.length == 1) {
                int linkStart = spanText.getSpanStart((Object)spans[0]);
                int linkEnd = spanText.getSpanEnd((Object)spans[0]);
                if (linkStart <= Utils.indexFirstNonWhitespaceChar((CharSequence)spanText) && linkEnd >= Utils.indexLastNonWhitespaceChar((CharSequence)spanText) + 1) {
                    return spanText;
                }
            }
            spanText = SpannableString.valueOf((CharSequence)text);
            if (lastDitchGeo && !text.isEmpty()) {
                Linkify.addLinks((Spannable)spanText, (Pattern)mWildcardPattern, (String)"geo:0,0?q=");
            }
            return spanText;
        }
        boolean linkifyFoundLinks = Linkify.addLinks((Spannable)spanText, (int)11);
        URLSpan[] existingSpans = (URLSpan[])spanText.getSpans(0, spanText.length(), URLSpan.class);
        Matcher coordMatcher = COORD_PATTERN.matcher((CharSequence)spanText);
        int coordCount = 0;
        while (coordMatcher.find()) {
            int end;
            int start = coordMatcher.start();
            if (Utils.spanWillOverlap((Spannable)spanText, existingSpans, start, end = coordMatcher.end())) continue;
            URLSpan span = new URLSpan("geo:0,0?q=" + coordMatcher.group());
            spanText.setSpan((Object)span, start, end, 33);
            ++coordCount;
        }
        existingSpans = (URLSpan[])spanText.getSpans(0, spanText.length(), URLSpan.class);
        int[] phoneSequences = Utils.findNanpPhoneNumbers(text);
        int phoneCount = 0;
        for (int match = 0; match < phoneSequences.length / 2; ++match) {
            int start = phoneSequences[match * 2];
            int end = phoneSequences[match * 2 + 1];
            if (Utils.spanWillOverlap((Spannable)spanText, existingSpans, start, end)) continue;
            StringBuilder dialBuilder = new StringBuilder();
            for (int i = start; i < end; ++i) {
                char ch = spanText.charAt(i);
                if (ch != '+' && !Character.isDigit(ch)) continue;
                dialBuilder.append(ch);
            }
            URLSpan span = new URLSpan("tel:" + dialBuilder.toString());
            spanText.setSpan((Object)span, start, end, 33);
            ++phoneCount;
        }
        if (lastDitchGeo && !text.isEmpty() && !linkifyFoundLinks && phoneCount == 0 && coordCount == 0) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"No linkification matches, using geo default");
            }
            Linkify.addLinks((Spannable)spanText, (Pattern)mWildcardPattern, (String)"geo:0,0?q=");
        }
        return spanText;
    }

    private static int indexFirstNonWhitespaceChar(CharSequence str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static int indexLastNonWhitespaceChar(CharSequence str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    static int[] findNanpPhoneNumbers(CharSequence text) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int startPos = 0;
        int endPos = text.length() - 7 + 1;
        if (endPos < 0) {
            return new int[0];
        }
        while (startPos < endPos) {
            while (Character.isWhitespace(text.charAt(startPos)) && startPos < endPos) {
                ++startPos;
            }
            if (startPos == endPos) break;
            int matchEnd = Utils.findNanpMatchEnd(text, startPos);
            if (matchEnd > startPos) {
                list.add(startPos);
                list.add(matchEnd);
                startPos = matchEnd;
                continue;
            }
            while (!Character.isWhitespace(text.charAt(startPos)) && startPos < endPos) {
                ++startPos;
            }
        }
        int[] result = new int[list.size()];
        for (int i = list.size() - 1; i >= 0; --i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    private static int findNanpMatchEnd(CharSequence text, int startPos) {
        int curPos;
        if (text.length() > startPos + 4 && text.subSequence(startPos, startPos + 4).toString().equalsIgnoreCase("tel:")) {
            startPos += 4;
        }
        int endPos = text.length();
        int foundDigits = 0;
        int firstDigit = 120;
        boolean foundWhiteSpaceAfterAreaCode = false;
        for (curPos = startPos; curPos <= endPos; ++curPos) {
            int ch = curPos < endPos ? (int)text.charAt(curPos) : 27;
            if (Character.isDigit((char)ch)) {
                if (foundDigits == 0) {
                    firstDigit = ch;
                }
                if (++foundDigits <= 11) continue;
                return -1;
            }
            if (Character.isWhitespace((char)ch)) {
                if (firstDigit == 49 && foundDigits == 4 || foundDigits == 3) {
                    foundWhiteSpaceAfterAreaCode = true;
                    continue;
                }
                if ((firstDigit != 49 || foundDigits != 1) && (!foundWhiteSpaceAfterAreaCode || (firstDigit != 49 || foundDigits != 7) && foundDigits != 6)) break;
                continue;
            }
            if (NANP_ALLOWED_SYMBOLS.indexOf(ch) == -1) break;
        }
        if (firstDigit != 49 && (foundDigits == 7 || foundDigits == 10) || firstDigit == 49 && foundDigits == 11) {
            return curPos;
        }
        return -1;
    }

    private static boolean spanWillOverlap(Spannable spanText, URLSpan[] spanList, int start, int end) {
        if (start == end) {
            return false;
        }
        for (URLSpan span : spanList) {
            int existingStart = spanText.getSpanStart((Object)span);
            int existingEnd = spanText.getSpanEnd((Object)span);
            if ((start < existingStart || start >= existingEnd) && (end <= existingStart || end > existingEnd)) continue;
            if (Log.isLoggable((String)TAG, (int)2)) {
                CharSequence seq = spanText.subSequence(start, end);
                Log.v((String)TAG, (String)("Not linkifying " + seq + " as phone number due to overlap"));
            }
            return true;
        }
        return false;
    }

    private static class CalendarBroadcastReceiver
    extends BroadcastReceiver {
        Runnable mCallBack;

        public CalendarBroadcastReceiver(Runnable callback) {
            this.mCallBack = callback;
        }

        public void onReceive(Context context, Intent intent) {
            if ((intent.getAction().equals("android.intent.action.DATE_CHANGED") || intent.getAction().equals("android.intent.action.TIME_SET") || intent.getAction().equals("android.intent.action.LOCALE_CHANGED") || intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) && this.mCallBack != null) {
                this.mCallBack.run();
            }
        }
    }

    private static class DNASegment {
        int startMinute;
        int endMinute;
        int color;
        int day;

        private DNASegment() {
        }
    }

    public static class DNAStrand {
        public float[] points;
        public int[] allDays;
        int position;
        public int color;
        int count;
    }
}

