/*
 * Decompiled with CFR 0.152.
 */
package be.bagofwords.virtualfile.remote;

import be.bagofwords.application.BaseServer;
import be.bagofwords.application.annotations.BowComponent;
import be.bagofwords.db.application.environment.RemoteCountDBEnvironmentProperties;
import be.bagofwords.ui.UI;
import be.bagofwords.util.WrappedSocketConnection;
import be.bagofwords.virtualfile.VirtualFile;
import be.bagofwords.virtualfile.VirtualFileService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

@BowComponent
public class RemoteFileServer
extends BaseServer {
    private VirtualFileService virtualFileService;

    @Autowired
    public RemoteFileServer(VirtualFileService virtualFileService, RemoteCountDBEnvironmentProperties properties) {
        super("RemoteFileServer", properties.getVirtualFileServerPort());
        this.virtualFileService = virtualFileService;
    }

    protected BaseServer.SocketRequestHandler createSocketRequestHandler(WrappedSocketConnection connection) throws IOException {
        return new SocketRequestHandler(connection);
    }

    public static enum Action {
        INPUT_STREAM,
        OUTPUT_STREAM,
        EXISTS;

    }

    private class SocketRequestHandler
    extends BaseServer.SocketRequestHandler {
        private long totalNumberOfRequests;

        public SocketRequestHandler(WrappedSocketConnection connection) throws IOException {
            super((BaseServer)RemoteFileServer.this, connection);
            this.totalNumberOfRequests = 0L;
        }

        protected void reportUnexpectedError(Exception ex) {
            UI.writeError((String)"Exception in socket request handler of remote file server", (Throwable)ex);
        }

        public long getTotalNumberOfRequests() {
            return this.totalNumberOfRequests;
        }

        protected void handleRequests() throws Exception {
            byte actionAsByte = this.connection.readByte();
            try {
                Action action = Action.values()[actionAsByte];
                if (action == Action.INPUT_STREAM) {
                    String relPath = this.connection.readString();
                    VirtualFile file = RemoteFileServer.this.virtualFileService.getRootDirectory().getFile(relPath);
                    if (file.exists()) {
                        InputStream is = file.createInputStream();
                        this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
                        IOUtils.copy((InputStream)is, (OutputStream)this.connection.getOs());
                        this.connection.flush();
                    } else {
                        this.connection.writeLong(Long.MAX_VALUE);
                        this.connection.writeString("Could not find file " + relPath);
                        this.connection.flush();
                    }
                } else if (action == Action.OUTPUT_STREAM) {
                    String relPath = this.connection.readString();
                    VirtualFile file = RemoteFileServer.this.virtualFileService.getRootDirectory().getFile(relPath);
                    OutputStream os = file.createOutputStream();
                    this.connection.writeLong(0x7FFFFFFFFFFFFFFEL);
                    this.connection.flush();
                    IOUtils.copy((InputStream)this.connection.getIs(), (OutputStream)os);
                } else if (action == Action.EXISTS) {
                    String relPath = this.connection.readString();
                    VirtualFile file = RemoteFileServer.this.virtualFileService.getRootDirectory().getFile(relPath);
                    this.connection.writeBoolean(file.exists());
                    this.connection.flush();
                } else {
                    this.connection.writeLong(Long.MAX_VALUE);
                    this.connection.writeString("Unknown command " + (Object)((Object)action));
                    this.connection.flush();
                }
            }
            catch (Exception exp) {
                this.connection.writeLong(Long.MAX_VALUE);
                this.connection.writeString(exp.getMessage());
                this.connection.flush();
                throw exp;
            }
        }
    }
}

